//Written by J. Laroche at the Center for Music Experiment at UCSD, San Diego //California. December 1990.

// A simple example showing how to set-up two streams to and from the DSP.
// This example performs simple sample rate conversion from 22050 to 44100.
// It checks whether the sound is mono or stereo, and signals it to the DSP
// using a host command before sending the data.


#import <sound/sound.h>
#import <sound/sounddriver.h>
#import <mach.h>
#import <stdio.h>

#define Error(A,B) if((A)) {fprintf(stderr,"%s %s\n",B, SNDSoundError((A)));\
mach_error(B,(A)); }

#define DMASIZE 4096

static int done;
static short *read_data;
static int read_count;


static void recorded_data(void *arg, int tag, void *p, int nbytes)
// This gets called when the entire result array has been read from DSP.
{
printf("Conversion done... \n");
	read_data = (short *)p;
	read_count = nbytes;
	done = 1;
}

static void read_started(void *arg, int tag)
// This gets called when the driver starts reading DSP.
{
printf("Starting converting... \n");
}




void main (int argc, char *argv[])
{
    static port_t dev_port, owner_port,cmd_port;
    static port_t reply_port, read_port, write_port;
    int i, protocol;
    kern_return_t k_err;
    SNDSoundStruct *sound;
    SNDSoundStruct *converted;
    SNDSoundStruct *dspStruct;
    snddriver_handlers_t handlers = { 0, 0, 
    		read_started, 0, 0, 0, 0, 0, recorded_data};
    msg_header_t *reply_msg;
    int low_water = 48*1024;
    int high_water = 64*1024;
    short *location,*blank;
    int WRITE_TAG = 1;
    int READ_TAG = 2;
    int length;
    int stereo = 0;
    

    if(argc == 1) { printf("I need a 16bit linear sound file...\n");
    exit(1);}

    k_err = SNDAcquire(SND_ACCESS_OUT|SND_ACCESS_DSP,0,0,0,
    	NULL_NEGOTIATION_FUN,0,&dev_port,&owner_port); 
    Error(k_err,"SND acquisition  ");
    
    k_err = snddriver_get_dsp_cmd_port(dev_port,owner_port,&cmd_port);

    k_err = SNDReadSoundfile(argv[1], &sound);
    Error(k_err,argv[1]);
        
    stereo = (sound->channelCount == 2);
    printf("Converting a %s sound\n",((stereo)?"stereo":"mono"));

    k_err = SNDGetDataPointer(sound,(char**)&location,&length,&i);
    Error(k_err,"Data Pointer");
  
    protocol = SNDDRIVER_DSP_PROTO_RAW;
    k_err = snddriver_stream_setup(dev_port, owner_port,
			SNDDRIVER_STREAM_TO_DSP,
			DMASIZE, 2, 
			low_water, high_water,
			&protocol, &write_port);
    Error(k_err,"Stream  ");
    k_err = snddriver_stream_setup(dev_port, owner_port,
			SNDDRIVER_STREAM_FROM_DSP,
			DMASIZE, 2, 
			low_water, high_water,
			&protocol, &read_port);
    Error(k_err,"Stream  ");

    k_err = snddriver_dsp_protocol(dev_port, owner_port, protocol);
    Error(k_err,"Protocol");
    
    k_err = port_allocate(task_self(),&reply_port);

    k_err = SNDReadDSPfile("convert22_44.lod", &dspStruct, NULL);
    Error(k_err,"DSP file");

    k_err = SNDBootDSP(dev_port, owner_port, dspStruct);
    Error(k_err,"DSP BOOT");

    if(!stereo)
    k_err = snddriver_dsp_host_cmd(cmd_port,20,SNDDRIVER_LOW_PRIORITY);

    k_err = snddriver_stream_start_writing(write_port,location,
	    length, WRITE_TAG,0,0,0,0,0,0,0,0, reply_port);
    Error(k_err,"Write Command");
    
    vm_allocate(task_self(),(vm_address_t *)(&blank),2*vm_page_size,TRUE);
    Error(k_err,"VM Allocation  ");
    
    k_err = snddriver_stream_start_writing(write_port,blank,
	    2*DMASIZE, WRITE_TAG,0,0,0,0,0,0,0,0, reply_port);
    Error(k_err,"Write Command");

    k_err = snddriver_stream_start_reading(read_port,0,2*length,READ_TAG,
					 	1,0,0,0,0,0, reply_port);
    Error(k_err,"Read command");

    reply_msg = (msg_header_t *)malloc(MSG_SIZE_MAX);
    done = 0;

    while (done != 1) 
	{
	    reply_msg->msg_size = MSG_SIZE_MAX;
	    reply_msg->msg_local_port = reply_port;
	    k_err = msg_receive(reply_msg, MSG_OPTION_NONE, 0);
	    k_err = snddriver_reply_handler(reply_msg,&handlers);
	}
    
    k_err = SNDAlloc(&converted,4*length, sound->dataFormat,SND_RATE_HIGH,
    sound->channelCount,4);
    Error(k_err,"SND Allocation");
    
    k_err = SNDGetDataPointer(converted,(char**)&location,&i,&i);
    Error(k_err,"Data Pointer");
    
    printf("Copying the sound...\n");
    for(i=0;i<2*length;i++)
	*location++ = *read_data++;
	
    k_err = SNDWriteSoundfile(argv[2], converted);
    Error(k_err,"Write Sound");
    
    vm_deallocate(task_self(),(pointer_t)read_data,read_count);
}


