//Written by J. Laroche at the Center for Music Experiment at UCSD, San Diego //California. December 1990.
// File useful to test the stream control capabilities of the driver for 
// writing streams (to the DACS). Currently (V. 2.0 prerelease fushia), 
// aborting the stream wedges more or less the driver.
// Moreover, pause and resume work on any tagged region, whatever its tag is.

#import <sound/sound.h>
#import <sound/sounddriver.h>
#import <mach.h>
#import <stdio.h>


#define Error(A,B) if((A)) {fprintf(stderr,"%s %s\n",B, SNDSoundError((A)));\
mach_error(B,(A)); }

static void read_completed(void *arg, int tag)
{
fprintf(stderr,"playing completed message called \n");
}

static void read_started(void *arg, int tag)
{
fprintf(stderr,"Playing Started message received \n");
}

static void read_aborted(void *arg, int tag)
{
fprintf(stderr,"Playing Aborted message received \n");
}

static void read_paused(void *arg, int tag)
{
fprintf(stderr,"Playing Paused message received \n");
}

static void read_resumed(void *arg, int tag)
{
fprintf(stderr,"Playing Resumed message received \n");
}



main (int argc, char *argv[])
{
    int i;
    static port_t dev_port, owner_port;
    static port_t reply_port, write_port;
    kern_return_t k_err;
    snddriver_handlers_t handlers = { 0, 0, 
    read_started,read_completed,read_aborted,read_paused,read_resumed, 0, 0};
    msg_header_t *reply_msg;
    SNDSoundStruct *sound;
    short *location;
    int low_water = 48*1024;
    int high_water = 128*1024;	// Choose a higher value for more security
    int DMASIZE = 4096;
    int WRITE_TAG = 1;
    int length,protocol;

    
    if(argc == 1) { printf("I need a 16bit linear sound file...\n");
    exit(1);}

    k_err = SNDAcquire(SND_ACCESS_OUT,0,0,0,
    		NULL_NEGOTIATION_FUN,0,&dev_port,&owner_port); 
    Error(k_err,"SND acquisition  ");
    
    k_err = port_allocate(task_self(),&reply_port);


    k_err = SNDReadSoundfile(argv[1], &sound);
    Error(k_err,argv[1]);

    k_err = SNDGetDataPointer(sound,(char**)&location,&length,&i);
    Error(k_err,"Data Pointer");

    k_err = snddriver_stream_setup(dev_port, owner_port,
			SNDDRIVER_STREAM_TO_SNDOUT_44,
			DMASIZE, 2, 
			low_water, high_water,
			&protocol, &write_port);
    Error(k_err,"Stream  ");
    
    reply_msg = (msg_header_t *)malloc(MSG_SIZE_MAX);
    while (1) 
	{
	int i;
	
	printf("1: receive message  2: write  3: abort 4:pause 5:resume\n");
	scanf("%d",&i);
	    switch(i)
	    {
		case 1 : 
		printf("Asking for messages ... \n");
		reply_msg->msg_size = MSG_SIZE_MAX;
		reply_msg->msg_local_port = reply_port;
		k_err = msg_receive(reply_msg, RCV_TIMEOUT, 500);
		Error(k_err,"Message  ");
		if(!k_err) snddriver_reply_handler(reply_msg,&handlers);
		break;
		
		case 2 :
		k_err = snddriver_stream_start_writing(write_port,location,
			length, WRITE_TAG,0,0,1,1,1,1,1,0, reply_port);
		Error(k_err,"Write Command  "); break ;
		
		case 3 : 
		snddriver_stream_control(write_port,1,SNDDRIVER_ABORT_STREAM);
		break ;
		
		case 4 : 
		snddriver_stream_control(write_port,2,SNDDRIVER_PAUSE_STREAM);
		break ;
		
		case 5 : 
		snddriver_stream_control(write_port,2,SNDDRIVER_RESUME_STREAM);
		break ;
	    }
	}
}



