;; A pitch shifter. This hasn't been optimized... but it works.
;; Incoming samples are stored in a ring buffer (input buffer), and read with
;; a read pointer which is incremented by a non integer value. The increment
;; is a three byte word whose first byte represents the integer part of the
;; increment, and whose two lower bytes are the decimal part. If the increment
;; is set to 1 ($010000), then the samples a read at the same speed they were
;; written, and the pitch is not altered. If the increment is higher or lower
;; then 1, the pitch is altered accordingly. The trick is that if the increment
;; is greater than one for example, the read pointer will read faster than the
;; write pointer, and will end up catching-up with it. When the two pointers 
;; are too close, an interpolation is performed to avoid a clic. You can hear
;; it as a periodic alteration of the signal with a period depending on the
;; rate of pitch shift and on the size of the ring buffer.
;;
;; Use host command 20 to pass the value of the pitch shift (65536 = no shift).
;; Use host command 21 to pass the value of the mix (mix = 0 means you only get
;; the shifted signal, mix = 1 means you get direct + shifted signals.) This 
;; works more or less like an harmonizer.

 
	include "ioequ.asm"

IW_Buff		equ	8192		;Start address of input buffer
OW_Buff		equ	12288		;Start address of output buffer
Buff_size	equ	4095
DMA_SIZE	equ	512
Limit		equ	320

DM_R_REQ	equ	$050001		;message -> host to request dma
VEC_R_DONE	equ	$0024		;host command indicating dma complete


;;;------------------------- Variable locations
;;;

x_sFlags	equ	$00fd		; dspstream flags
DMA_DONE	equ	0		; indicates that dma is complete
phase		equ	$00fe		; Current phase (in l memory)
increment	equ	$01		; increment
mask		equ	$02		; mask
flipflop	equ	$03		; Stereo Flip-flop
save_a		equ	$04		; Where to save register a
save_b		equ	$05		; Where to save register b
updown		equ	$06		; Is the shift up or down ?
offset		equ	$07		 
stop		equ	$08		; Stop DMA flag
mix		equ	$09


cra_init 	equ	$4100           ;
crb_init 	equ	$0a00 		;
pcc     	equ	$1e0            ; 
pcddr	 	equ	$01c            ;
pcd_init 	equ	$0010            ;

	org	p:$0			
	jmp	reset

	org	p:VEC_R_DONE
	bset	#DMA_DONE,x:x_sFlags
	
	org	p:$C			;SSI data received interrupt
	jsr	input

	org	p:$E			;SSI data received exception interrupt
	jsr	except

	org	p:40			
	jsr	getPitch

	org	p:42			
	jsr	getMix

	org	p:60			
	bset	#0,x:stop

	org	p:$100
	
reset
	movec   #6,omr			;data rom enabled, mode 2
	bset    #0,x:m_pbc		;host port
	bset	#3,x:m_pcddr		;   pc3 is an output with value
	bclr	#3,x:m_pcd		;   zero to enable the external ram
	movep   #>$000000,x:m_bcr	;no wait states on the external sram
        movep   #>$00BC00,x:m_ipr  	;intr levels: SSI=2, SCI=1, HOST=2
	clr	a
	move	a,x:x_sFlags		;clear flags
	bset    #m_hcie,x:m_hcr		;host command interrupts
	move	#0,sr			;enable interrupts
	
;;	Configure SSI port

	movep   #cra_init,x:m_cra   	;     Program up SSI port, as 
	movep   #crb_init,x:m_crb   	;     documented above.
	
	movep   #pcd_init,x:m_pcd   	;   
	movep   #pcddr,x:m_pcddr	;  
	movep   #pcc,x:m_pcc        	;

;;	Configure variables

	move	#>IW_Buff+2,R1
	move	#>OW_Buff+2,R0
	move	#>OW_Buff,R7
	move	#>Buff_size,M0
	move	#>Buff_size,M7
	move	#>Buff_size,M1
	jmp	main
	
		
main
	move 	#>IW_Buff,R2
	move 	#>IW_Buff,R4
	move 	#>Buff_size,M2
	move 	#>Buff_size,M4
	move	#>0,R5
	move	#>1,M5
	move	#>IW_Buff+Buff_size,a
	move	a,x:mask
	move	#>$18000,a		; pitch shift of a fifth up.
	move	a,x:increment
	clr	a
	move	a,l:phase
	move	a,x:mix
	move	#>1,a
	move	a,x:updown
	move	#>Limit+4,a
	move	a,x:offset
	bset	#m_srie,x:m_crb
	bset	#m_sre,x:m_crb		;SSI Receive enable
	bclr	#0,x:stop

_main_loop
	jset	#0,x:stop,_main_loop	
	jclr	#m_htde,x:m_hsr,_main_loop	;(optional!)
	movep	#DM_R_REQ,x:m_htx	;    send "DSP_dm_R_REQ" to host
_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	;    wait for HF1 to go high
	move	#>DMA_SIZE,b
	do	b,_prodDMA
_send
	move	R0,a
	move	R7,b
	cmp	a,b
	jeq	_send
	move	y:(R7)+,a
_wait
	jclr	#m_htde,x:m_hsr,_wait
	move	a,x:m_htx	
_prodDMA
	btst	#DMA_DONE,x:x_sFlags
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_prodDMA
	movep	#0,x:m_htx		;send zeros until noticed
	jmp	_prodDMA
_endDMA
	bclr	#DMA_DONE,x:x_sFlags	;be sure we know we are through
_ackEnd
	jmp	_main_loop


	
getPitch
	movep	x:m_hrx,x:increment 
	move	a,x:save_a
	move	x:increment,a 
	move	#>$10000,X0		; $10000 is a one sample increment
	cmp	X0,a
	move	x:save_a,a
	jlt	_Greater
	move	#>1,X0			; if shift up, adjust updown and offset
	move	X0,x:updown
	move	#>Limit+4,X0
	move	X0,x:offset
	rti
_Greater				; if shift down, same thing
	move	#>0,X0
	move	X0,x:updown
	move	#>-Limit-4,X0
	move	X0,x:offset
	rti
	
getMix
	movep	x:m_hrx,x:mix
	rti
	
	
input
	movep	x:m_rx,x:(R1)+		; Store the incoming ssi sample
	move	a,x:save_a		; Store a and b registers
	move	b,x:save_b
	move	#>.999,X0		; Default values for X0 and X1
	move	#>0,X1
	move	(R2)+N2			; Compare the read and write pointers.
	move	R1,a 			; Write pointer
	move	R2,b			; Read pointer
	move	(R2)-N2
	sub	a,b #>Buff_size,Y1	
	jclr	#0,x:updown,_foo
	neg	b			; if Shift up, negate the distance
_foo					; between pointers.
	and	Y1,b #>Limit,a		; Compute modulo Buffer_size
	move	b1,Y0
	cmp	Y0,a  #>1./Limit,Y1	; If the two pointers are not too close
	jlt	_endLoop		; do nothing special
	mpy	Y0,Y1,b #>2,a		; if not, interpolate, and
	cmp	Y0,a  x:offset,N4	; if they are really close
	jlt	_suite			
	move	R4,R2			; move the Read pointer forward, or
	move	(R4)+N4			; backward, depending on up or down.
	jmp	_endLoop		
_suite
	asr	b  #>$7FFFFF,a		; This is the interpolation (a = 1.)
	move	b0,Y0
	sub	Y0,a  b0,X0
	move	a,X1			; X0 and X1 now contain the two weights
_endLoop
	jsr	interp			; get the new sample
	move	b,y:(R0)+		; and put it in the output ring
	move	x:save_a,a		; restore a and b registers.
	move	x:save_b,b
	rti				
	
	
interp
	move	l:phase,a		; The phase is a long word
	move	a1,b			; The high phase points to the look-up
	asl	b  x:mask,Y1		; table
	and	Y1,b  R5,x:flipflop	; The phase is masked.
	move	R5,Y0			; R5 indicates left/rigth channel
	or	Y0,b (R5)+		; If left, add 1 to the pointer.
_cont
	move	b,N2
	move	b,N4
	move	#>2,Y0
	add	Y0,b	x:(R2+N2),Y0	; 
	and	Y1,b    x:(R4+N4),Y1	;
	mpyr	Y0,X0,b b,N2		;
	macr	Y1,X1,b N2,N4		; b = Value 0
	move	a0,a
	lsr	a  x:(R2+N2),Y0		
	move	x:(R4+N4),Y1
	mpyr	Y0,X0,a  a1,Y0
	macr	Y1,X1,a  #>$80,Y1	; a = Value 1
	sub	b,a x:mix,X0			; a = Value 1 - Value 0
	move 	a,X1 				; X1 = Value 1 - Value 0
	mac	X1,Y0,b	x:increment,Y0		; Final Value!
	move	x:-(R1),X1
	macr	X0,X1,b (R1)+
	move	b,X1
	move	#>$7FFF,X0
	mpyr	X0,X1,b  l:phase,a 
	jclr	#0,x:flipflop,_cont2	; If right, do not increment the phase
	mac	Y0,Y1,a  x:mask,Y1
	and	Y1,a			; The phase is masked.
_cont2
	move	a,l:phase 		; ... and saved
	rts

	
except
	movep	x:m_sr,a
	movep	x:m_rx,a		; Must read the SSI status register,
	rti				; then RX, in order to reset ROE.

	

