
/* Generated by Interface Builder */

#import "Stereo.h"
#define TWOPOW23 8388608

@implementation Stereo

- open
{
int s_err;
int i;

    [super open];
    SNDReadDSPfile([self findPath:"/DSP_Code/Stereo.lod"], &Effect, NULL);

    s_err = SNDBootDSP(dev_port, owner_port, Effect);
    if (s_err != SND_ERR_NONE) {
	fprintf(stderr,"Cannot boot dsp : %s\n", SNDSoundError(s_err));
	exit(1);
    }
    for(i=0;i<3;i++)
    {
	[sliders selectCellWithTag:1+i];
	[self sliderChange:sliders];
    }
    printf("DSP booted\n");
    return self;
}

- sliderChange:sender
{
float fvalue ;
int tag, value, DSPCommand;

    tag = [[sender selectedCell] tag]-1;
    if(tag < 0) return self;
    DSPCommand = 20+tag;
    fvalue = [[sender selectedCell] floatValue];
    if(![button intValue]) [button setIntValue:1];
    switch(tag)
    {
	case 0 : value =  (int) (fvalue * 2047) ; break ; 
	case 1 : value =  (int) (fvalue * 2047) ; break ; 
	case 2 : value = (int) (TWOPOW23-1) * fvalue ; break ;
    }
    snddriver_dsp_write(cmd_port,&value,1,sizeof(int),SNDDRIVER_HIGH_PRIORITY);
    snddriver_dsp_host_cmd(cmd_port,DSPCommand,SNDDRIVER_MED_PRIORITY);
    return self;
}

- buttonPush:sender
{
int i, value = 0;

    switch([sender intValue])
    {
	case 0 : for(i=0;i<3;i++)
	    {
    snddriver_dsp_write(cmd_port,&value,1,sizeof(int),SNDDRIVER_HIGH_PRIORITY);
    snddriver_dsp_host_cmd(cmd_port,20+i,SNDDRIVER_MED_PRIORITY); 
	    } break ;
	case 1 : for(i=0;i<3;i++)
	    {
		[sliders selectCellWithTag:1+i];
		[self sliderChange:sliders];
	    } break ;
    }
    return self;
}


@end
