
/* Generated by Interface Builder */

#import "IIR.h"
#import <math.h>
#define TWOPOW23 8388608

@implementation IIR

- open
{
int s_err;
int i;

    [super open];
    SNDReadDSPfile([self findPath:"/DSP_Code/IIR.lod"], &Effect, NULL);

    s_err = SNDBootDSP(dev_port, owner_port, Effect);
    if (s_err != SND_ERR_NONE) {
	fprintf(stderr,"Cannot boot dsp : %s\n", SNDSoundError(s_err));
	exit(1);
    }
    for(i=0;i<4;i++)
    {
	[sliders selectCellWithTag:1+i];
	[self sliderChange:sliders];
    }
    printf("DSP booted\n");
    return self;
}

- sliderChange:sender
{
float fvalue ;
int tag, value, real_value, mod_value, gain_value;
static float argument, gain, modulus = 0.98 ;

    tag = [[sender selectedCell] tag]-1;
    fvalue = [[sender selectedCell] floatValue];
    switch(tag)
    {
	case 1 : modulus = 1 - exp((fvalue-1)*2*log(10.)) ; break ;
	case 2 : argument = exp((fvalue-1)*8*log(2.)) ; break ; 
	case 3 : gain = exp((fvalue-1)*2*log(10.)) ; break ; 
    }
    switch(tag)
    {
	case 0 : value = (int) fvalue ;
    snddriver_dsp_write(cmd_port,&value,1,sizeof(int),SNDDRIVER_HIGH_PRIORITY);
    snddriver_dsp_host_cmd(cmd_port,20,SNDDRIVER_MED_PRIORITY); break ;
	default : 
	real_value = TWOPOW23 * modulus * cos (3.1416 * argument) ;
	mod_value =  - TWOPOW23 * modulus * modulus / 2 ;
	gain_value = TWOPOW23 * gain * sqrt( (1-modulus)*(1+modulus*modulus
	- 2 * modulus * cos(6.2832*argument)));
snddriver_dsp_write(cmd_port,&gain_value,1,sizeof(int),SNDDRIVER_HIGH_PRIORITY);snddriver_dsp_host_cmd(cmd_port,23,SNDDRIVER_MED_PRIORITY); snddriver_dsp_write(cmd_port,&real_value,1,sizeof(int),SNDDRIVER_HIGH_PRIORITY);snddriver_dsp_host_cmd(cmd_port,21,SNDDRIVER_MED_PRIORITY);
snddriver_dsp_write(cmd_port,&mod_value,1,sizeof(int),SNDDRIVER_HIGH_PRIORITY);
snddriver_dsp_host_cmd(cmd_port,22,SNDDRIVER_MED_PRIORITY); break ;
    }
    return self;
}

@end
