
	include "ioequ.asm"

IW_Buff		equ	8192		;Start address of input buffer
OW_Buff		equ	12288		;Start address of output buffer
Buff_size	equ	4095
DMA_SIZE	equ	512

DM_R_REQ	equ	$050001		;message -> host to request dma
VEC_R_DONE	equ	$0024		;host command indicating dma complete


;;;------------------------- Variable locations
;;;

x_sFlags	equ	$00fd		;dspstream flags
DMA_DONE	equ	0		;  indicates that dma is complete
Stop_Flag	equ	$00		; Stop DMA flag
save_a		equ	$01
sink		equ	$02
coef1		equ	$04
coef2		equ	$05
lag1		equ	$08
lag2		equ	$09


cra_init 	equ	$4100           ;
crb_init 	equ	$0a00 		;
pcc     	equ	$1e0            ; 
pcddr	 	equ	$01c            ;
pcd_init 	equ	$0010            ;

	org	p:$0			
	jmp	reset
	nop

	org	p:VEC_R_DONE
	bset	#DMA_DONE,x:x_sFlags
	nop
	
	org	p:$C			;SSI data received interrupt
	movep	x:m_rx,y:(R0)+		
	nop

	org	p:$E			;SSI data received exception interrupt
	jsr	except
	nop

	org	p:40			
	jsr	get0
	nop

	org	p:42			
	jsr	get1
	nop

	org	p:44			
	jsr	get2
	nop

	org	p:60			
	jsr	stop
	nop

	org	p:100
	
reset
	movec   #6,omr			;data rom enabled, mode 2
	bset    #0,x:m_pbc		;host port
	bset	#3,x:m_pcddr		;   pc3 is an output with value
	bclr	#3,x:m_pcd		;   zero to enable the external ram
	movep   #>$000000,x:m_bcr	;no wait states on the external sram
        movep   #>$00BC00,x:m_ipr  	;intr levels: SSI=2, SCI=1, HOST=2
	clr	a
	move	a,x:x_sFlags		;clear flags
	bset    #m_hcie,x:m_hcr		;host command interrupts
	move	#0,sr			;enable interrupts
	
;;	Configure SSI port

	movep   #cra_init,x:m_cra   	;     Program up SSI port, as 
	movep   #crb_init,x:m_crb   	;     documented above.
	
	movep   #pcd_init,x:m_pcd   	;   
	movep   #pcddr,x:m_pcddr	;  
	movep   #pcc,x:m_pcc        	;

;;	Configure variables

	move	#>IW_Buff+2,R0
	move	#>OW_Buff,R1
	move	#>IW_Buff,R7
	move	#>4,R2
	move	#>8,R3
	move	#>Buff_size,M0
	move	#>Buff_size,M7
	move	#>Buff_size,M1
	move	#>1,M2
	move	#>1,M3
	jmp	main
	
		
main
	move	#>$7FFF,X0
	move	#>-1001,a
	move	a,x:lag1
	move	#>-1001,a
	move	a,x:lag2
	move	a,N1
	move	a,N7
	move	#>.45,a
	move	a,x:coef1
	move	a,x:coef2
	clr	a
	do	#2,_fin
	move	a,y:(R7+N7)
	move	a,y:(R7)+
	move	a,y:(R1+N1)	; Make sure the first 2 samples are null
	move	(R1)+
_fin
	move	#>OW_Buff,R1
	move	#>IW_Buff,R7
	bclr	#0,x:Stop_Flag
	bclr	#1,x:Stop_Flag
	bset	#m_srie,x:m_crb
	bset	#m_sre,x:m_crb		;SSI Receive enable

_main_loop
	jset	#0,x:Stop_Flag,_main_loop	;
	jclr	#m_htde,x:m_hsr,_main_loop	;(optional!)
	movep	#DM_R_REQ,x:m_htx	;    send "DSP_dm_R_REQ" to host
_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	;    wait for HF1 to go high
	move	#>DMA_SIZE,b
	bset	#1,x:Stop_Flag
	jcs	_normal
	clr	a #>DMA_SIZE-2,b	
	do	#2,_normal
_take
	jclr	#m_htde,x:m_hsr,_take
	move	a,x:m_htx
_normal
	do	b,_prodDMA
_send
	move	R0,a
	move	R7,b
	cmp	a,b
	jeq	_send
	move	y:(R7),Y0		; Input must be mono!
	move	x:(R3)+,N7		; Get the time lag
	move	x:(R2)+,Y1		; Get the feedback coefficient
	mpy	Y0,Y1,a N7,N1
	move	y:(R7+N7),Y0
	add	Y0,a
	move	y:(R1+N1),Y0
	macr	-Y0,Y1,a
	move	a,y:(R1)+
	move	a,Y0
	mpyr	Y0,X0,a	(R7)+	
_wait
	jclr	#m_htde,x:m_hsr,_wait
	move	a,x:m_htx	
_prodDMA
	btst	#DMA_DONE,x:x_sFlags
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_prodDMA
	movep	#0,x:m_htx		;send zeros until noticed
	jmp	_prodDMA
_endDMA
	bclr	#DMA_DONE,x:x_sFlags	;be sure we know we are through
_ackEnd
;	jset	#m_hf1,x:m_hsr,_ackEnd	;wait for HF1 to go low (optional!)
	jmp	_main_loop


	
except
	movep	x:m_sr,a
	movep	x:m_rx,a		; Must read the SSI status register,
	rti				; then RX, in order to reset ROE.

stop
	bset	#0,x:Stop_Flag
	rti
	
get0
	move	a,x:save_a
	movep	x:m_hrx,a
	asl	a #>1,X1
	add	X1,a
	neg	a 
	move	a,x:lag1
	move	x:save_a,a
	rti	

get1
	move	a,x:save_a
	movep	x:m_hrx,a
	asl	a #>1,X1
	add	X1,a
	neg	a 
	move	a,x:lag2
	move	x:save_a,a
	rti	

get2
	move	a,x:save_a
	movep	x:m_hrx,x:coef2 
	move	x:coef2,a
	move	a,x:coef1 
	move	x:save_a,a
	rti	
		

