;; Simple DSP Program that sends values from the Digital ears (SSI port) to the
;; Host, using DMA protocol. When initialized, it is blocked, waiting for a 
;; Host Command #31 (62 on DSP) to start sending DMA buffers.

	include "ioequ.asm"

IW_Buff		equ	8192		;Start address of input buffer
OW_Buff		equ	12288		;Start address of output buffer
Buff_size	equ	4095
Read_num	equ	$00fe
DMA_SIZE	equ	4096

DM_R_REQ	equ	$050001		;message -> host to request dma
VEC_R_DONE	equ	$0024		;host command indicating dma complete


;;;------------------------- Variable locations
;;;

x_sFlags	equ	$00fd		; dspstream flags
DMA_DONE	equ	0		; indicates that dma is complete
Stop_Flag	equ	$000		; DMA stop flag
bull		equ	$1


cra_init 	equ	$4100           ;
crb_init 	equ	$0a00 		;
pcc     	equ	$1e0            ; 
pcddr	 	equ	$01c            ;
pcd_init 	equ	$0010            ;

	org	p:$0			
	jmp	reset

	org	p:VEC_R_DONE
	bset	#DMA_DONE,x:x_sFlags
	nop
	
	org	p:$C			;SSI data received interrupt
	movep	x:m_rx,y:(R0)+		
	nop

	org	p:$E			;SSI data received exception interrupt
	jsr	except
	nop

	org	p:60			
	bset	#0,x:Stop_Flag
	nop

	org	p:62			
	bclr	#0,x:Stop_Flag
	nop

	org	p:100
	
reset
	movec   #6,omr			;data rom enabled, mode 2
	bset    #0,x:m_pbc		;host port
	bset	#3,x:m_pcddr		;   pc3 is an output with value
	bclr	#3,x:m_pcd		;   zero to enable the external ram
	movep   #>$000000,x:m_bcr	;no wait states on the external sram
        movep   #>$00BC00,x:m_ipr  	;intr levels: SSI=2, SCI=1, HOST=2
	clr	a
	move	a,x:x_sFlags		;clear flags
	bset    #m_hcie,x:m_hcr		;host command interrupts
	move	#0,sr			;enable interrupts
	
;;	Configure SSI port

	movep   #cra_init,x:m_cra   	;     Program up SSI port, as 
	movep   #crb_init,x:m_crb   	;     documented above.
	
	movep   #pcd_init,x:m_pcd   	;   
	movep   #pcddr,x:m_pcddr	;  
	movep   #pcc,x:m_pcc        	;

;;	Configure variables

	move	#>IW_Buff+2,R0
	move	#>OW_Buff,R1
	move	#>IW_Buff,R7
	move	#>Buff_size,M0
	move	#>Buff_size,M7
	move	#>Buff_size,M1
	jmp	main
	
		
main
	move	#>$7FFF,X0
	bclr	#0,x:Stop_Flag		
	bset	#m_srie,x:m_crb
	bset	#m_sre,x:m_crb		;SSI Receive enable

_main_loop
	jset	#0,x:Stop_Flag,_main_loop	;
	jclr	#m_htde,x:m_hsr,_main_loop	;(optional!)
	movep	#DM_R_REQ,x:m_htx	;    send "DSP_dm_R_REQ" to host
_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	;    wait for HF1 to go high
	move	#>DMA_SIZE,b
	do	b,_prodDMA
_send
	move	R0,a
	move	R7,b
	cmp	a,b
	jeq	_send
	move	y:(R7)+,Y0
	mpyr	Y0,X0,a		
	move	a,x:(R1)+
_wait
	jclr	#m_htde,x:m_hsr,_wait
	move	a,x:m_htx	
_prodDMA
	btst	#DMA_DONE,x:x_sFlags
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_prodDMA
	movep	#0,x:m_htx		;send zeros until noticed
	jmp	_prodDMA
_endDMA
	bclr	#DMA_DONE,x:x_sFlags	;be sure we know we are through
_ackEnd
;	jset	#m_hf1,x:m_hsr,_ackEnd	;wait for HF1 to go low (optional!)
	jmp	_main_loop


	
except
	movep	x:m_sr,a		; When SSI has been under-run
	movep	x:m_rx,a		; Must read the SSI status register,
	rti				; then RX, in order to reset ROE.

		

