;;Written by J. Laroche at the Center for Music Experiment at UCSD, San Diego ;;California. December 1990.

;; An example showing how to receive samples from the host (NON DMA protocol)
;; and how to send them back, using DMA protocol. 
;; We accumulate up to MAX_BUFF_NUM DMA buffers in the input buffer, and send
;; them to the host. If the sound is mono, the C program sends a host command
;; to set a flag, and the DSP copies each sample twice in the buffer, since the
;; output stream must be interleaved (left rigth left right.)
;; Since the data come from the host NON-DMA, blanks and drop out are likely
;; to happen, when the sound file sampling rate is 44100...
 
	include "ioequ.asm"

IW_Buff		equ	8192		; Start address of input buffer
Buff_size	equ	8191		; Size of buffer
DMA_SIZE	equ	2048
MAX_BUFF_NUM	equ	2		; Max number of non sent buffer 

DM_R_REQ	equ	$050001		;message -> host to request dma
VEC_R_DONE	equ	$0024		;host command indicating dma complete



;;;------------------------- Variable locations
;;;

x_sFlags	equ	$00fd		; dspstream flags
DMA_DONE	equ	0		; indicates that dma is complete
save_a		equ	$01		; Where to save register a
save_b		equ	$02		; Where to save register b
bull		equ	$03		; Auxiliary variable.
stereo		equ	$04		; stereo flag


	org	p:$0			
	jmp	reset

	org	p:VEC_R_DONE
	bset	#DMA_DONE,x:x_sFlags
	
	org	p:$20			; Host receive interrupt, called when-
	jsr	input			; ever the host sends a sample.

	org	p:$28			
	bset	#0,x:stereo			

	org	p:$100
	
reset
	movec   #6,omr			;data rom enabled, mode 2
	bset    #0,x:m_pbc		;host port
	bset	#3,x:m_pcddr		;   pc3 is an output with value
	bclr	#3,x:m_pcd		;   zero to enable the external ram
	movep   #>$000000,x:m_bcr	;no wait states on the external sram
        movep   #>$00BC00,x:m_ipr  	;intr levels: SSI=2, SCI=1, HOST=2
	clr	a
	move	a,x:x_sFlags		;clear flags
	bset    #m_hcie,x:m_hcr		;host command interrupts
	move	#0,sr			;enable interrupts
	

;;	Configure variables

	bclr	#0,x:stereo
	move	#>IW_Buff,R0
	move	#>IW_Buff,R7
	move	#>0,R2			; DMA buffers counter
	move	#>0,R3			; Sample counter
	move	#>Buff_size,M0
	move	#>Buff_size,M7
	jmp	main
	
		
main
 	bset	#m_hrie,x:m_hcr		; Enable interrupt for host write.
	move	#>MAX_BUFF_NUM,a
	move	R2,b
	cmp	a,b			; Start by accumulating a number of
	jne	main			; DMA buffers.
	

_main_loop				; Here's the main loop!!
	move	R2,a
	tst	a			; Do we have a DMA buffer to send?
	jeq	_main_loop
	jsr	send_DMA		; if yes, send it!
	jmp	_main_loop		; until the cows come home.
	

send_DMA				; Sends a DMA buffer
	jclr	#m_htde,x:m_hsr,send_DMA
	movep	#DM_R_REQ,x:m_htx	; send "DSP_dm_R_REQ" to host
	move	(R2)-			; Decrement the buffer count.
_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	;    wait for HF1 to go high
	move	#>DMA_SIZE,b
	do	b,_prodDMA
	move	y:(R7)+,a		; and pass the values to the host.
_wait
	jclr	#m_htde,x:m_hsr,_wait
	move	a,x:m_htx	
_prodDMA
	btst	#DMA_DONE,x:x_sFlags
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_prodDMA
	movep	#0,x:m_htx		;send zeros until noticed
	jmp	_prodDMA
_endDMA
	bclr	#DMA_DONE,x:x_sFlags	;be sure we know we are through
_ackEnd
	bset	#m_hrie,x:m_hcr
	rts	


;; input is called by the host receive interrupt vector, each time a sample is
;; written by the host.
		
input
	move	a,x:save_a		; Store a and b registers
	move	b,x:save_b
	movep	x:m_hrx,x:bull		; get the sample
	move	x:bull,a
	jclr	#15,x:bull,_ooo		; This is a modification which corrects
	move	#>$FF,a2		; the driver's "bug". It sign-extends
	move	#>$FF0000,X1		; the received short value,if necessary
	or	X1,a	
_ooo					; now the correct value is in a.
	move	(R3)+			; otherwise, we store it in the buffer. 
	move	a,y:(R0)+
	btst	#0,x:stereo		; If the sound is mono,
	jcc	_comp
	move	(R3)+			; copy another sample in the buffer 
	move	a,y:(R0)+		; for the other channel
_comp	
	move	#>DMA_SIZE,b
	move	R3,a
	cmp	a,b			; do we have a full DMA buffer?
	jeq	_equ			
	move	x:save_a,a		; if not, restore a and b and return.
	move	x:save_b,b
	rti	
_equ					; we do have a full DMA buffer.
	move	(R2)+			; DMA buffer count.
	move	#>0,R3
	move	R2,a
	move	#>MAX_BUFF_NUM,b	; We don't want more than MAX_BUFF_NUM
	cmp	a,b			; pending DMA buffers.
	jne	_continue
	bclr	#m_hrie,x:m_hcr		; stop receiving samples if too many...
_continue	
	move	x:save_a,a
	move	x:save_b,b
	rti
	

