;;Written by J. Laroche at the Center for Music Experiment at UCSD, San Diego ;;California. December 1990.

Sine		set	0	; Replace 0 by 1 if you don't have digital ears
				; The DSP will just create a sine wave.

	include "ioequ.asm"

IW_Buff		equ	8192		; Start address of input buffer
Buff_size	equ	4095		; Length of this buffer - 1.
DMA_SIZE	equ	512

DM_R_REQ	equ	$050001		; message -> host to request dma
VEC_R_DONE	equ	$0024		; host command indicating dma complete
DMA_DONE	equ	0		; indicates that dma is complete


;;;------------------------- Variable locations
;;;

x_sFlags	equ	$00fd		; dspstream flags
Stop_Flag	equ	$000		; Stop DMA flag
volume		equ	$001		; Volume


cra_init 	equ	$4100           ;
crb_init 	equ	$0a00 		;
pcc     	equ	$1e0            ; 
pcddr	 	equ	$01c            ;
pcd_init 	equ	$0010           ;


	org	p:$0			
	jmp	reset

	org	p:VEC_R_DONE
	bset	#DMA_DONE,x:x_sFlags
	nop
	
	org	p:$C			;SSI data received interrupt
	movep	x:m_rx,y:(R0)+
	nop	

	org	p:$E			;SSI data received exception interrupt
	jsr	except
	nop

	org	p:40			;Host Command interrupt		
	jsr	getVolume
	nop

	org	p:60			;Host Command interrupt
	jsr	stop
	nop

	org	p:62			;Host Command interrupt
	jsr	go
	nop

	org	p:100			; Beginning address of program.
	
reset
	movec   #6,omr			;data rom enabled, mode 2
	bset    #0,x:m_pbc		;host port
	movep   #>$000000,x:m_bcr	;no wait states on the external sram
        movep   #>$00BC00,x:m_ipr  	;intr levels: SSI=2, SCI=1, HOST=2
	bset    #m_hcie,x:m_hcr		;host command interrupts
	move	#0,sr			;enable interrupts
	
;;	Configure SSI port

	movep   #cra_init,x:m_cra   	
	movep   #crb_init,x:m_crb   	
	movep   #pcd_init,x:m_pcd   	   
	movep   #pcddr,x:m_pcddr	  
	movep   #pcc,x:m_pcc        	

;;	Configure variables

	clr	a
	move	a,x:x_sFlags		;clear flags
	move	#>IW_Buff,R0
	move	#>IW_Buff,R7
	move	#>Buff_size,M0
	move	#>Buff_size,M7
	if Sine
	move	#>$100,R1
	move	#>$FF,M1
	endif
	jmp	main
	
		
main
	move	#>.9,a
	move	a,x:volume
	bclr	#0,x:Stop_Flag
	bset	#m_srie,x:m_crb
	bset	#m_sre,x:m_crb		;SSI Receive enable
	
_main_loop
	jset	#0,x:Stop_Flag,_main_loop	
	jclr	#m_htde,x:m_hsr,_main_loop	
	movep	#DM_R_REQ,x:m_htx	;    send "DSP_dm_R_REQ" to host
_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	;    wait for HF1 to go high
	move	#>DMA_SIZE,b
	do	b,_prodDMA
_send
	move	R0,a
	move	R7,b
	cmp	a,b
	jeq	_send
	move	y:(R7)+,Y0
	if Sine	
	    move	y:(R1)+,Y0	; If no digital ears, sine wave...
	endif
	move	x:volume,X0
	mpyr	Y0,X0,a	#>$8000,X0
	move	a,Y0
	mpyr	X0,Y0,a	
_wait
	jclr	#m_htde,x:m_hsr,_wait
	move	a,x:m_htx	
_prodDMA
	btst	#DMA_DONE,x:x_sFlags
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_prodDMA
	movep	#0,x:m_htx		;send zeros until noticed
	jmp	_prodDMA
_endDMA
	bclr	#DMA_DONE,x:x_sFlags	;reset the flag!
_ackEnd
	jset	#m_hf1,x:m_hsr,_ackEnd	;wait for HF1 to go low (optional!)
	jmp	_main_loop


	
except
	movep	x:m_sr,a
	movep	x:m_rx,a		; Must read the SSI status register,
	rti				; then RX, in order to reset ROE.

stop
	bset	#0,x:Stop_Flag
	rti

go
	bclr	#0,x:Stop_Flag
	rti
	
getVolume
	movep	x:m_hrx,x:volume 
	rti	
	
	

