//Written by J. Laroche at the Center for Music Experiment at UCSD, San Diego //California. December 1990.

// A simple example recording from the CODEC microphone

#import <sound/sound.h>
#import <sound/sounddriver.h>
#import <mach.h>
#import <stdio.h>

#define Error(A,B) if((A)) {fprintf(stderr,"%s %s\n",B, SNDSoundError((A)));\
mach_error(B,(A)); }

#define DMASIZE 4096
#define READ_TAG 1

static int done;
static char *read_data;
static int read_count;


static void recorded_data(void *arg, int tag, void *p, int nbytes)
// This gets called when the entire result array has been read from SNDIN.
{
printf("Recording done... \n");
	read_data = (char *)p;
	read_count = nbytes;
	done = 1;
}

static void read_started(void *arg, int tag)
// This gets called when the driver starts reading SNDIN.
{
printf("Starting recording... \n");
}




main (int argc, char *argv[])
{
    static port_t dev_port, owner_port;
    static port_t reply_port, read_port;
    int i, protocol;
    kern_return_t k_err;
    snddriver_handlers_t handlers = { 0, 0, 
    		read_started, 0, 0, 0, 0, 0, recorded_data};
    msg_header_t *reply_msg;
    int low_water = 48*1024;
    int high_water = 64*1024;

    

    k_err = SNDAcquire(SND_ACCESS_IN,0,0,0,
    	NULL_NEGOTIATION_FUN,0,&dev_port,&owner_port); 
    Error(k_err,"SND acquisition  ");
    
    
    k_err = snddriver_stream_setup(dev_port, owner_port,
    				 SNDDRIVER_STREAM_FROM_SNDIN,
				 DMASIZE, 1, 
				 low_water, high_water,
				 &protocol, &read_port);
    Error(k_err,"Stream set_up");
    
    k_err = port_allocate(task_self(),&reply_port);
    k_err = snddriver_stream_start_reading(read_port,0,32000,READ_TAG,
					 	1,0,0,0,0,0, reply_port);
    Error(k_err,"Starting reading  ");

    reply_msg = (msg_header_t *)malloc(MSG_SIZE_MAX);
    done = 0;

    while (done != 1) 
	{
	    reply_msg->msg_size = MSG_SIZE_MAX;
	    reply_msg->msg_local_port = reply_port;
	    k_err = msg_receive(reply_msg, MSG_OPTION_NONE, 0);
	    k_err = snddriver_reply_handler(reply_msg,&handlers);
	}
    
    // print a few received samples...

    for (i=5000; i<5020; i++)
	printf("sample[%d] = %d \n",i,read_data[i]);

    vm_deallocate(task_self(),(pointer_t)read_data,read_count);
}


