; Fast DMA tries to implement a loop such that the time between the reception
;; of a sample and that of its sending to the DMA buffer is minimized. This 
; achives the minimum possible delay. 

	include "ioequ.asm"

IW_Buff		equ	8192		;Start address of input buffer
OW_Buff		equ	12288		;Start address of output buffer
Buff_size	equ	4095
Read_num	equ	$00fe
DMA_SIZE	equ	512

DM_R_REQ	equ	$050001		;message -> host to request dma
VEC_R_DONE	equ	$0024		;host command indicating dma complete


;;;------------------------- Variable locations
;;;

x_sFlags	equ	$00fd		;dspstream flags
DMA_DONE	equ	0		;  indicates that dma is complete
y_sCurSamp	equ	$00fc		;current offset in buffer
phase		equ	$00		;Current phase (in l memory)
increment	equ	$01		;increment
mask		equ	$02		;mask
Stop_Flag	equ	$03		; Stop Sending Flag
Sink		equ	$04		
Direct		equ	$05		
Modu		equ	$06
save_a		equ	$07		
save_b		equ	$08		

cra_init 	equ	$4100           ;
crb_init 	equ	$0a00 		;
pcc     	equ	$1e0            ; 
pcddr	 	equ	$01c            ;
pcd_init 	equ	$0010            ;

	org	p:$0			
	jmp	reset
	nop
	
	org	p:VEC_R_DONE
	bset	#DMA_DONE,x:x_sFlags
	nop

	org	p:$C			;SSI data received interrupt
	movep	x:m_rx,y:(R0)+
	nop

	org	p:$E			;SSI data received exception interrupt
	jsr	except
	nop

	org	p:40			
	jsr	get0
	nop

	org	p:42			
	jsr	get1
	nop

	org	p:60			
	jsr	stop
	nop

	org	p:100
	
reset
	movec   #6,omr			;data rom enabled, mode 2
	bset    #0,x:m_pbc		;host port
	bset	#3,x:m_pcddr		;   pc3 is an output with value
	bclr	#3,x:m_pcd		;   zero to enable the external ram
	movep   #>$000000,x:m_bcr	;no wait states on the external sram
        movep   #>$00BC00,x:m_ipr  	;intr levels: SSI=2, SCI=1, HOST=2
	clr	a
	move	a,x:x_sFlags		;clear flags
	bset    #m_hcie,x:m_hcr		;host command interrupts
	move	#0,sr			;enable interrupts
	
;;	Configure SSI port

	movep   #cra_init,x:m_cra   	;     Program up SSI port, as 
	movep   #crb_init,x:m_crb   	;     documented above.
	
	movep   #pcd_init,x:m_pcd   	;   
	movep   #pcddr,x:m_pcddr	;  
	movep   #pcc,x:m_pcc        	;

;;	Configure variables

	move	#>IW_Buff+2,R0
	move	#>IW_Buff,R7
	move	#>Buff_size,M0
	move	#>Buff_size,M7
	jmp	main
	
		
main
	move 	#>$0100,R2
	move 	#>$00FF,M2
	move	#>$3FFF,X0
	move	#>1,N2
	move	#>$FF,a
	move	a,x:mask
	move	#>$10000,a
	move	a,x:increment
	clr	a
	move	a,y:(R7)+
	move	a,y:(R7)-	; Make sure the 2 first samples are null
	move	a,l:phase
	move	#>.99,a
	move	a,x:Direct
	bclr	#0,x:Stop_Flag
	bclr	#1,x:Stop_Flag
	bset	#m_srie,x:m_crb
	bset	#m_sre,x:m_crb		;SSI Receive enable

_main_loop
	jset	#0,x:Stop_Flag,_main_loop	
	jclr	#m_htde,x:m_hsr,_main_loop	;(optional!)
	movep	#DM_R_REQ,x:m_htx	;    send "DSP_dm_R_REQ" to host
_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	;    wait for HF1 to go high
	move	#>DMA_SIZE,b
	bset	#1,x:Stop_Flag
	jcs	_normal
	clr	a #>DMA_SIZE-2,b	
	do	#2,_normal
_take
	jclr	#m_htde,x:m_hsr,_take
	move	a,x:m_htx
_normal
	do	b,_prodDMA
_send
	move	R0,a
	move	R7,b
	cmp	a,b
	jeq	_send
	jsr	sine
	move	x:Modu,Y1
	move	#>.999,b
	sub	Y1,b y:(R7)+,X0
	move	b,Y1
	mpyr	X0,Y1,b x:Modu,Y0
	move	a,Y1
	mpyr	Y0,Y1,a  
	move	a,Y1
	macr	X0,Y1,b #>$7FFF,Y0
	move	b,Y1
	mpyr	Y0,Y1,a
	
_wait
	jclr	#m_htde,x:m_hsr,_wait
	move	a,x:m_htx	
_prodDMA
	btst	#DMA_DONE,x:x_sFlags
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_prodDMA
	movep	#0,x:m_htx		;send zeros until noticed
	jmp	_prodDMA
_endDMA
	bclr	#DMA_DONE,x:x_sFlags	;be sure we know we are through
_ackEnd
;	jset	#m_hf1,x:m_hsr,_ackEnd	;wait for HF1 to go low (optional!)
	jmp	_main_loop


	
except
	movep	x:m_sr,a
	movep	x:m_rx,a		; Must read the SSI status register,
	rti				; then RX, in order to reset ROE.

	
get0
	movep	x:m_hrx,x:increment 
	rti	
	
get1
	movep	x:m_hrx,x:Modu 
	rti	
	
stop
	bset	#0,x:Stop_Flag 
	rti	
	
sine
	move	l:phase,a		; The phase is a long word
	move	a1,N2			; The high phase points to the look-up
	nop				; table:
	move	y:(R2+N2),Y0		; Y0 = Value 0 
	move	(R2)+
	move	y:(R2+N2),b		; b = Value 1
	move	(R2)-
	sub	Y0,b			; b = Value 1 - Value 0
	move	a0,Y1			; Y1 = Low phase 
	move 	b,X1			; X1 = Value 1 - Value 0
	move	Y1,b			; Y1 is a non signed fractional number
	lsr	b			; lsr converts it into a positive
	move	b1,Y1			; signed fractional with same abs value
	move	Y0,b
	mac	X1,Y1,b			; Final Value!
	move	x:increment,X1
	move	#>$80,Y1		; Increment scaler (Part of the increment is added to the high phase, part to the low phase)
	mac	X1,Y1,a
	move	x:mask,X1
	and	X1,a			; The phase is masked.
	move	a,l:phase		; Updated phase is stored.
	move	b,a
	rts				


