
	include "ioequ.asm"

IW_Buff		equ	8192		;Start address of input buffer
OW_Buff		equ	12288		;Start address of output buffer
Buff_size	equ	8191
DMA_SIZE	equ	512

DM_R_REQ	equ	$050001		;message -> host to request dma
VEC_R_DONE	equ	$0024		;host command indicating dma complete


;;;------------------------- Variable locations
;;;

x_sFlags	equ	$00fd		;dspstream flags
DMA_DONE	equ	0		;  indicates that dma is complete
Stop_Flag	equ	$000		; Stop DMA flag
lag		equ	$01
mask		equ	$02
save_a		equ	$03
save_x0		equ	$04
save_y0		equ	$05
phase		equ	$06
increment	equ	$07
mask_sin	equ	$08
mod		equ	$09
level		equ	$0A

cra_init 	equ	$4100           ;
crb_init 	equ	$0a00 		;
pcc     	equ	$1e0            ; 
pcddr	 	equ	$01c            ;
pcd_init 	equ	$0010            ;

	org	p:$0			
	jmp	reset

	org	p:VEC_R_DONE
	bset	#DMA_DONE,x:x_sFlags
	nop
	
	org	p:$C			;SSI data received interrupt
	movep	x:m_rx,y:(R0)+		
	nop

	org	p:$E			;SSI data received exception interrupt
	jsr	except
	nop

	org	p:40			
	jsr	get0
	nop

	org	p:42			
	jsr	get1
	nop

	org	p:44			
	jsr	get2
	nop

	org	p:46			
	jsr	get3
	nop

	org	p:60			
	jsr	stop
	nop

	org	p:100
	
reset
	movec   #6,omr			;data rom enabled, mode 2
	bset    #0,x:m_pbc		;host port
	bset	#3,x:m_pcddr		;   pc3 is an output with value
	bclr	#3,x:m_pcd		;   zero to enable the external ram
	movep   #>$000000,x:m_bcr	;no wait states on the external sram
        movep   #>$00BC00,x:m_ipr  	;intr levels: SSI=2, SCI=1, HOST=2
	clr	a
	move	a,x:x_sFlags		;clear flags
	bset    #m_hcie,x:m_hcr		;host command interrupts
	move	#0,sr			;enable interrupts
	
;;	Configure SSI port

	movep   #cra_init,x:m_cra   	;     Program up SSI port, as 
	movep   #crb_init,x:m_crb   	;     documented above.
	
	movep   #pcd_init,x:m_pcd   	;   
	movep   #pcddr,x:m_pcddr	;  
	movep   #pcc,x:m_pcc        	;

;;	Configure variables

	move	#>IW_Buff+2,R0
	move	#>IW_Buff,R7
	move	#>Buff_size,M0
	move	#>Buff_size,M7
	jmp	main
	
		
main
	move	#>2000,a
	move	#>0,a0
	move	a,l:lag
	clr	a #>Buff_size+1,b
	rep	b
	move	a,y:(R0)+
	move	a,l:phase
	move	#>$C00,a
	move	a,x:increment
	move	#>.01,a
	move	a,x:mod
	move	#>.999,a
	move	a,x:level
	move	#>$100,R4
	move	#>$FF,M4
	move	#>$FF,a
	move	a,x:mask_sin
	bclr	#0,x:Stop_Flag
	bclr	#1,x:Stop_Flag
	bset	#m_srie,x:m_crb
	bset	#m_sre,x:m_crb		;SSI Receive enable

_main_loop
	jset	#0,x:Stop_Flag,_main_loop	;
	jclr	#m_htde,x:m_hsr,_main_loop	;(optional!)
	movep	#DM_R_REQ,x:m_htx	;    send "DSP_dm_R_REQ" to host
_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	;    wait for HF1 to go high
	move	#>DMA_SIZE,b
	bset	#1,x:Stop_Flag
	jcs	_normal
	clr	a #>DMA_SIZE-2,b	
	do	#2,_normal
_take
	jclr	#m_htde,x:m_hsr,_take
	move	a,x:m_htx
_normal
	do	b,_prodDMA
_send
	move	R0,a
	move	R7,b
	cmp	a,b
	jeq	_send
	jsr	sine
	move	l:lag,b
	move	a,X0
	move	#>$8000,X1
	mpy	X0,X1,a	x:mod,X0
	move	a,X1
	mac	X0,X1,b
	abs	b
	move	b1,a
	asl	a 
	neg	a  b0,b
	move	a,N7
	nop
	lsr	b x:(R7+N7),a
	move	(R7)-
	move	(R7)-
	move	b1,X1
	move	x:(R7+N7),b
	sub	a,b (R7)+
	move	(R7)+
	move	b,Y1
	macr	X1,Y1,a y:(R7)+,b
	move	a,X0
	move	x:level,X1
	macr	X0,X1,b #>$3FFF,X0
	move	b,Y0
	mpyr	Y0,X0,a
_wait
	jclr	#m_htde,x:m_hsr,_wait
	move	a,x:m_htx	
_prodDMA
	btst	#DMA_DONE,x:x_sFlags
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_prodDMA
	movep	#0,x:m_htx		;send zeros until noticed
	jmp	_prodDMA
_endDMA
	bclr	#DMA_DONE,x:x_sFlags	;be sure we know we are through
_ackEnd
;	jset	#m_hf1,x:m_hsr,_ackEnd	;wait for HF1 to go low (optional!)
	jmp	_main_loop


	
except
	movep	x:m_sr,a
	movep	x:m_rx,a		; Must read the SSI status register,
	rti				; then RX, in order to reset ROE.

stop
	bset	#0,x:Stop_Flag
	rti
	
get0
	movep	x:m_hrx,x:increment 
	rti	

get1
	movep	x:m_hrx,x:lag 
	rti	

get2
	movep	x:m_hrx,x:mod 
	rti	

get3
	movep	x:m_hrx,x:level 
	rti	


sine
	move	l:phase,Y		; The phase is a long word
	move	Y1,N4 
	nop 
	move	y:(R4+N4),X0			
	tfr	Y0,b	(R4)+
	move	y:(R4+N4),a
	sub	X0,a  (R4)- 
	lsr	b  a,X1
	tfr	X0,a b1,X0
	mac	X1,X0,a x:increment,X1 
	tfr	Y1,b    #>$80,X0
	move	Y0,b0  
	mac	X1,X0,b	x:mask_sin,X1
	and	X1,b 	
	move	b,l:phase
	rts				


	
	

