
/* Generated by Interface Builder */

#import "Chorus.h"
#import <math.h>
#define TWOPOW23 8388608

float chorus[4] = {0.15,0.9,0.5,0.95};
float phasing[4] = {0.1,0.6,0.5,0.95};
float vibrato[4] = {0.4,0.8,0.6,0.95};
float weird[4] = {0.8,0.8,0.5,0.95};

@implementation Chorus

- open
{
int s_err;
int i;

    [super open];
    SNDReadDSPfile([self findPath:"/DSP_Code/Chorus.lod"], &Effect, NULL);

    s_err = SNDBootDSP(dev_port, owner_port, Effect);
    if (s_err != SND_ERR_NONE) {
	fprintf(stderr,"Cannot boot dsp : %s\n", SNDSoundError(s_err));
	exit(1);
    }
    for(i=0;i<4;i++)
    {
	[sliders selectCellWithTag:1+i];
	[self sliderChange:sliders];
    }
    printf("DSP booted\n");
    return self;
}

- sliderChange:sender
{
float fvalue ;
int tag, value, DSPCommand;

    tag = [[sender selectedCell] tag]-1;
    if(tag < 0) return self;
    DSPCommand = 20+tag;
    fvalue = [[sender selectedCell] floatValue];
    switch(tag)
    {
	case 0 : value =  (int) exp((fvalue *14+4)*log(2)) ; break ; 
	case 1 : value =  (int) exp((fvalue *3)*log(10)) ; break ; 
	case 2 : value = (int) (TWOPOW23 * 0.01) * fvalue ; break ;
	case 3 : value = (int) (TWOPOW23 - 1) * fvalue ; break ;
    }
    snddriver_dsp_write(cmd_port,&value,1,sizeof(int),SNDDRIVER_HIGH_PRIORITY);
    snddriver_dsp_host_cmd(cmd_port,DSPCommand,SNDDRIVER_MED_PRIORITY);
    return self;
}

- buttonPush:sender
{
int i;
float *aux;

    switch([[sender selectedCell] tag])
    {
	case 0 : aux = chorus ; break ;
	case 1 : aux = phasing ; break ;
	case 2 : aux = vibrato ; break ;
	case 3 : aux = weird ; break ;
    }
    for(i=0;i<4;i++)
	{
	    [sliders selectCellWithTag:1+i];
	    [sliders setFloatValue:aux[i]];
	    [self sliderChange:sliders];
	} 
    return self;
}


@end
