typedef enum {
	SD_NO_ERROR	= 100,	// non-error ack.
	SD_BAD_PORT	= 101,	// message sent to wrong port
	SD_BAD_MSG	= 102,	// unknown message id
	SD_BAD_PARM	= 103,	// bad parameter list in message
	SD_NO_MEMORY	= 104,	// can't allocate memory (record)
	SD_PORT_BUSY	= 105,	// access req'd to existing excl access port
	SD_NOT_OWNER	= 106,	// must be owner to do this
	SD_BAD_CHAN	= 107,	// dsp channel hasn't been inited
	SD_SEARCH	= 108,	// couldn't find requested resource
	SD_NODATA	= 109,	// can't send data commands to dsp in this mode
	SD_NOPAGER	= 110,	// can't allocate from external pager (record).
	SD_NOTALIGNED	= 111,	// bad data alignment.
	SD_BAD_HOST_PRIV = 112,	// bad host privilege port passed.
	SD_BAD_PROTO 	= 113	// can't do requested operation in cur protocol
} SDError;

#define SD_MAX_ERROR 	113

char *sd_error_string(int error);
void sd_error(char *msg,int error);
