#import <sound/sounderror.h>	/* for SNDSoundError() */
#import <stdio.h>

#import "sd_error.h"

static char *sd_error_list[] = {
	"sound success",
	"sound message sent to wrong port",
	"unknown sound message id",
	"bad parameter list in sound message",
	"can't allocate memory for recording",
	"sound service in use",
	"sound service requires ownership",
	"DSP channel not initialized",
	"can't find requested sound resource",
	"bad DSP mode for sending data commands",
	"external pager support not implemented",
	"sound data not properly aligned",
	"bad host provilege port passed",
	"can't do requested operation in extant DSP protocol"
};

/*
 * Error code to string conversion
 */
extern char *mach_error_string();

char *sd_error_string(int error)
{
    if (error <= 0)
      return mach_error_string(error);
    else if (error >= SD_NO_ERROR && error <= SD_MAX_ERROR)
      return sd_error_list[error-SD_NO_ERROR];
    else
      return SNDSoundError(error);
}

void sd_error(char *msg,int error)
{
    char *errtype;
    if (error <= 0)
      errtype = "mach";
    else if (error >= SD_NO_ERROR && error <= SD_MAX_ERROR)
      errtype = "snddriver";
    else
      errtype = "sound";
    fprintf(stderr,"%s\n\t%s error:%s\n",msg,errtype,
	    sd_error_string(error));
}

