; DSP monitor illustrating DMA in and out of the DSP.
; J.O. Smith, NeXT Inc., 10/17/90.
; Last updated 7/24/91.
;
	page 255,255,0,1,1	   	; Width, height, topmar, botmar, lmar
	include 'ioequ.asm'

;--- Program configuration ---

;The macro BUG56 is defined by the Makefile
BUG56_VERSION	set BUG56 	; Set 0 for real thing, 1 for standalone Bug56
DEBUG_VERSION	set 0		; Set to 0 after DSP code is debugged
SLOW_VERSION	set 0		; 1 = simple&slow dma, 0 = the good stuff

	if BUG56_VERSION||DEBUG_VERSION
START		equ 	$A0	; Leaves room for Bug56's degmon monitor
	else
START		equ 	$40	; Leaves room for interrupt vectors
	endif

;--- DMA configuration ---

		define	R_DMA 'R3'	; Dedicated to DMA in
		define	N_DMA 'N3'	; Unused
		define	M_DMA 'M3'	; -1

		define	R_DMA_IN 'R6'	; Dedicated to DMA in
		define	N_DMA_IN 'N6'	; Unused
		define	M_DMA_IN 'M6'	; -1

		define	R_DMA_OUT 'R7'	; Dedicated to DMA out
		define	N_DMA_OUT 'N7'	; Unused
		define	M_DMA_OUT 'M7'	; -1

	if !SLOW_VERSION
	if BUG56_VERSION
DMA_READ_SIZE	equ	$0004	; Size of each DMA transfer in 
DMA_WRITE_SIZE	equ	$0004	; Size of each DMA transfer out
READ_BUF1	equ	$3000	; First input buffer
READ_BUF2	equ	$3004	; Second input buffer
WRITE_BUF1	equ	$3008	; First output buffer
WRITE_BUF2	equ	$300C	; Second output buffer
	else
DMA_READ_SIZE	equ	$0800	; Size of each DMA transfer in 
DMA_WRITE_SIZE	equ	$0800	; Size of each DMA transfer out
READ_BUF1	equ	$2000	; First input buffer
READ_BUF2	equ	$2800	; Second input buffer
WRITE_BUF1	equ	$3000	; First output buffer
WRITE_BUF2	equ	$3800	; Second output buffer
	endif
	else
DMA_READ_SIZE	equ	$0800	; Size of each DMA transfer in 
DMA_WRITE_SIZE	equ	$0800	; Size of each DMA transfer out
READ_BUF1	equ	$3000	; Input buffer
WRITE_BUF1	equ	$3800	; Output buffer
Y_DMASTAT	equ	$0	; On-chip Y memory word used for status bits
Y_SYSCALL	equ	$1	; On-chip Y memory word used for syscall arg
	endif

;-------------------------

	if BUG56_VERSION
; 	  Do NOT assemble the reset vector for Bug56 version.
	else 
	  org p:0
	  jmp reset
	endif

	org p:START
;
; reset - first thing executed when DSP boots up - must be on-chip
;
reset	movec   #6,omr			; Data rom enabled, mode 2 = "normal"
	if DEBUG_VERSION
	  move	#2,sp			; leave room for Bug56 stack use
	else
	  move	#0,sp			; clear stack
	endif
	bset    #0,x:m_pbc		; Enable host port
	bset	#3,x:m_pcddr		;    pc3 asserts 0 to enable external
	bclr	#3,x:m_pcd		;    DSP ram on very early machines
	movep   #>$000000,x:m_bcr	; No wait states for the external sram
        movep   #>$00B400,x:m_ipr  	; Intr levels: SSI=2, SCI=1, HOST=0
	move	#0,sr			; go to lowest int. priority level
	jmp 	main
;
; input/output routines, DMA and non-DMA i/o
;
	if SLOW_VERSION
	  include 'simple_dma_support.asm'
	else
	  include 'fast_dma_support.asm'
	endif
;
; main -- read scale factor, then loop forever scaling input signal
;
main
	if BUG56_VERSION
	  move #0.5,X0			; test scale factor = 0.5
        else
	  readWordHost Y0		; read scale factor (programmed i/o)
	  if DEBUG_VERSION
	    move #0.5,A 		; 1/2 in DSP number format
	    cmp Y0,A
	    jsne abort
	  endif
	endif
	jsr dma_start			; Reset DMA state machine
loop	readWordDMA Y1 			; read next input sample (DMA)
	mpy Y0,Y1,A			; apply scale factor
	writeWordDMA A			; output sample (DMA)
	jmp loop

	if DEBUG_VERSION
abort	  bset #m_hf2,x:m_hcr	; abort code = HF2 and HF3
	  bset #m_hf3,x:m_hcr	; abort code = HF2 and HF3
	  jmp *
	endif

	end reset

	if *>$200
		warn 'Internal P memory overflow!' ; fatal for 8K SRAM
	endif

