//    This is part of the iostream library, providing input/output for C++.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "ioconfig.h"

#if defined(IMPLEMENT_STDIO) && defined(RENAME_STDIO)
// This is a kludge used by streambuf.C.  It is needed because
// streambuf.C contains the actual definitions of stdio, but
// it lies about their type.  (I.e. the type that streambuf.C
// internally defines stdin to have is not the same as the type
// that stdio.h declares stdin to have.)
#define stdin STDIN
#define stdout STDOUT
#define stderr STDERR
#include "stdio.h"
#undef stdin
#undef stdout
#undef stderr
#include "local.h"
#else
#include <stdio.h>
#endif

#include "std.h"
#include "streambu.h"
#include <stdarg.h>

#define _fstat(x, y) fstat(x,y)
#define _isatty(fd) isatty(fd)

extern int __vsbprintf(streambuf *, char const *, va_list);
extern int __sbprintf(streambuf *sb, const char* format, ...);
extern int __vsbscanf(streambuf *, char const *, va_list);
extern int __sbscanf(streambuf *, char const *, ...);
extern int __sbvwrite(streambuf *fp, struct __suio *uio);
extern int __cvt_double(double number, register int prec, int flags,
			char *signp, int fmtch, char *startp, char *endp);

#ifdef IMPLEMENT_STDIO
#define CIN_STREAMBUF stdin
#define COUT_STREAMBUF stdout
#define CERR_STREAMBUF stderr
#define CLOG_STREAMBUF stderr

#define __validfp(fp) \
  (((fp->_flags & _IO_MAGIC_MASK) == _OLD_STDIO_MAGIC && \
    (fp = *(FILE**)&((int*)fp)[1])), \
   __checkfp(fp))
#define __checkfp(fp) (fp->_flags & _IO_MAGIC_MASK) == _IO_MAGIC

inline streambuf* FILE_to_streambuf(FILE* fp)
{
    if ((fp->_flags & _IO_MAGIC_MASK) == _OLD_STDIO_MAGIC)
	return *(streambuf**)&((int*)fp)[1];
    if ((fp->_flags & _IO_MAGIC_MASK) == _IO_MAGIC)
	return (streambuf*)fp;
    return NULL;
}
#endif
