//    This is part of the iostream library, providing input/output for C++.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define RENAME_STDIO
#include "ioprivat.h"

#ifdef __GNUG__
#pragma implementation
#endif

size_t streambuf::sputn(const char* s, size_t n) // OPTIMIZE THIS!
{
    size_t count = 0;
    for (; count < n; count++) {
	if (sputc(*s++) == EOF)
	    break;
    }
    return count;
}

size_t streambuf::sgetn(char* s, size_t n) // OPTIMIZE THIS!
{
    size_t count = 0;
    for (; count < n; count++) {
	int ch = sbumpc();
	if (ch == EOF)
	    break;
	*s++ = ch;
    }
    return count;
}

int streambuf::sync()
{
    if (gptr() == egptr() && pptr() == pbase())
	return 0;
    return EOF;
}

int streambuf::pbackfail(int c)
{
    return EOF;
}

streambuf* streambuf::setbuf(char* p, size_t len)
{
    setb(p, p+len, 0);
    setp(0, 0);
    setg(0, 0, 0);
    return this;
}

// I'm unclear what seekpos is supposed to accomplish.
streampos streambuf::seekpos(streampos pos, int mode = ios::in|ios::out)
{
    return seekoff(pos, ios::beg, mode);
}

void streambuf::setb(char* b, char* eb, int a)
{
    if (_base && (_flags & _S_USER_BUF))
	free(_base);
    _base = b;
    _ebuf = eb;
    if (a)
	_flags &= ~_S_USER_BUF;
    else
	_flags |= _S_USER_BUF;
}

#ifdef atarist
extern "C" { extern unsigned long __DEFAULT_BUFSIZ__; }

int streambuf::doallocate()
{
    char *buf = malloc((size_t)__DEFAULT_BUFSIZ__);
    if (buf == NULL)
	return EOF;
    setb(buf, buf+__DEFAULT_BUFSIZ__, 1);
    return 1;
}
#else
int streambuf::doallocate()
{
    char *buf = malloc((size_t)BUFSIZ);
    if (buf == NULL)
	return EOF;
    setb(buf, buf+BUFSIZ, 1);
    return 1;
}
#endif

#ifdef atarist
extern "C" extern int __default_mode__;
#endif

streambuf::streambuf()
{
#ifdef atarist
  _flags = _IO_MAGIC | ((__default_mode__)? _S_IS_BINARY : 0);
#else
  _flags = _IO_MAGIC;
#endif
  _base = NULL;
  _ebuf = NULL;
  _eback = NULL;
  _gptr = NULL;
  _egptr = NULL;
  _pbase = NULL;
  _pptr = NULL;
  _epptr = NULL;
  _chain = NULL; // Not necessary.
}

streambuf::~streambuf()
{
    if (_base && !(_flags & _S_USER_BUF))
	free(_base);
}

int streambuf::underflow()
{
    return EOF;
}

int streambuf::overflow(int c = EOF)
{
    return EOF;
}

streamoff streambuf::seekoff(streamoff, seek_dir, int mode=ios::in|ios::out)
{
    return EOF;
}

int streambuf::sputbackc(char c)
{
    if (gptr() <= eback()) return pbackfail(c);
    gbump(-1);
    if (*gptr() != c)
	*gptr() = c;
    return (unsigned char)c;
}

#ifdef IMPLEMENT_STDIO
int __underflow(FILE* stream)
{
    return ((streambuf*)stream)->underflow();
}

int __overflow(FILE* stream, int c)
{
    return ((streambuf*)stream)->overflow(c);
}
#endif

extern char vt_filebuf[1] asm(FILEBUF_VT_NAME);

struct fake_filebuf {
    struct __streambuf s;
    char* vtable;
    struct __file_fields f;
};

#ifdef LITTLE_ENDIAN
#define INIT_FILE_FIELDS(FD) {0, 0, FD}
#else
#define INIT_FILE_FIELDS(FD) {FD, 0, 0}
#endif

#define DEF_STD(NAME, FD, CHAIN, FLAGS) \
    fake_filebuf NAME[1] = {{\
       { _IO_MAGIC+_S_IS_FILEBUF+FLAGS, 0, 0, 0, 0, 0, 0, 0, 0, CHAIN},\
       vt_filebuf,\
       INIT_FILE_FIELDS(FD)}};

#

#ifndef atarist
DEF_STD(CIN_STREAMBUF, 0, 0, _S_CAN_READ);
DEF_STD(COUT_STREAMBUF, 1, (streambuf*)CIN_STREAMBUF, _S_CAN_WRITE);
DEF_STD(CERR_STREAMBUF, 2, (streambuf*)COUT_STREAMBUF, _S_CAN_WRITE);
#else
DEF_STD(CIN_STREAMBUF, 0, 0, _S_CAN_READ+_S_LINE_BUF);
DEF_STD(COUT_STREAMBUF, 1, (streambuf*)CIN_STREAMBUF, _S_CAN_WRITE+_S_LINE_BUF);
DEF_STD(CERR_STREAMBUF, 2, (streambuf*)COUT_STREAMBUF, _S_CAN_WRITE+_S_LINE_BUF);
/* this bombs
DEF_STD(CERR_STREAMBUF, 2, (streambuf*)COUT_STREAMBUF, _S_CAN_WRITE+_S_UNBUFFERED);
*/
#endif

DEF_STD(not_open_filebuf, -1, (streambuf*)0, 0);

streambuf* __stream_list = (streambuf*)CERR_STREAMBUF;

static void flush_all()
{
    streambuf *stream;
    for (stream = __stream_list; stream != NULL; stream = stream->_chain)
	stream->overflow(EOF);
}

struct __io_defs {
    __io_defs() { }
    ~__io_defs() { flush_all(); }
};
__io_defs io_defs__;

#ifdef IMPLEMENT_STDIO
extern "C" void _cleanup() { flush_all(); } // For GNU libc.
#endif
