/* Copyright (C) 1989, 1992, 1993 Aladdin Enterprises.  All rights reserved.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gp_atar2.h */

/* Ghostscript header file for the Atari platform. */

extern FILE *OutFile;

/*
 * Global structures.
 */

extern WINLIST *WList;
extern WINTEXT Cons;

extern WINDOW aboutwin;
extern WINDOW reswin;
extern WINDOW devwin;
extern WINDOW sizwin;
extern WINDOW iconwin;
extern WINDOW printwin;
extern WINDOW pagewin;
extern WINDOW imagwin;
extern WINDOW conswin;

extern EVENT Event;

/*
 * Menu event handler functions.
 */

extern int HandleMenu(VWRK *, PSTATE *, GRAPHIC *,
		      stream_cursor_write *, byte **);
extern void HandleHelp(const char *, VWRK *, PSTATE *,
		       stream_cursor_write *, byte **);
extern int HandleOpen(VWRK *, PSTATE *, stream_cursor_write *, byte **);
extern int HandlePrev(PSTATE *);
extern int HandleNext(PSTATE *, stream_cursor_write *, byte **);
extern void HandleCycle(int);

/*
 * Window event handler functions.
 */

extern void HandleOntop(VWRK *);
extern void HandleUntop(VWRK *);
extern int HandleClose(PSTATE *, stream_cursor_write *, byte **);
extern void HandleArrow(PSTATE *);
extern void HorizontalSlider(PSTATE *);
extern void VerticalSlider(PSTATE *);
extern void HandleFull(PSTATE *, VWRK *);
extern void HandleMove(PSTATE *);
extern void HandleSize(PSTATE *);
extern void HandleIcon(VWRK *, PSTATE *);
extern void HandleUnIcon(VWRK *, PSTATE *);
extern int HandleButton(VWRK *, PSTATE *, GRAPHIC *,
			stream_cursor_write *, byte **);

/*
 * Misc. event handler functions.
 */

extern int HandleRedraw(int, PSTATE *);
extern int HandleKeybd(VWRK *, PSTATE *, stream_cursor_write *, byte **);
extern void HandlePageFilter(VWRK *, PSTATE *,
			     stream_cursor_write *, byte **);
extern void HandlePageSelect(VWRK *, PSTATE *,
			     stream_cursor_write *, byte **, int);

/*
 * Window I/O routines.
 */

extern void Cursor(int);
extern void NextLine(int);
extern void ClearLine(int);
extern void ClearWin(GRECT *);
extern int VisibleCols(WINDOW *);
extern int VisibleLines(WINDOW *);

/*
 * Centronics I/O routines (donated by Chris Strunk).
 */

extern void lputc(int);
extern void lputs(const char *);
extern void lflush(void);
extern void l_start(void);
extern void l_stop(void);
extern void fatal(const char *);
extern void con_flush(void);

/*
 * Real versions of the following functions are needed in gp_atar2.
 */

#undef fputc
#undef fputs
#undef fwrite

/* end gp_atar2.h */
