/*
 *	These definitions intercept I/0 for printing to windows
 *	or directly to the Centronics port on Atari computers.
 */

#ifndef __STDIO_H__
#include <stdio.h>
#endif

#define fputc   csputc
#define fputs   csputs
#define fwrite  cswrite
#define fprintf gemprintf

#if __GNUC__ >= 2
extern int gemprintf(FILE *stream, const char *format, ...) __attribute__((format(printf, 2, 3)));
#else
extern int gemprintf(FILE *stream, const char *format, ...);
#endif
extern int csputc(int c, FILE *stream);
extern int csputs(const char *s, FILE *stream);
extern size_t cswrite(const void *ptr, size_t size, size_t nobj, FILE *stream);
