/* Copyright (C) 1989, 1992, 1993 Aladdin Enterprises.  All rights reserved.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* ataridef.h */

#ifndef st_defs_h_INCLUDED
#define st_defs_h_INCLUDED

/* Definitions for the Atari platforms. */

#define MIN(x, y) ((x <= y) ? x : y)
#define MAX(x, y) ((x >= y) ? x : y)

/* Window Types. */

#define TEXT	(0)
#define OBJ	(1)
#define BIT	(2)

/* Definitions which determine the size of the console window. */

#define FIXED_CONSOLE_SIZE 0
#if FIXED_CONSOLE_SIZE
#  define LINES         (24)
#  define COLUMNS       (80)
#  define MAX_LINES     LINES
#  define MAX_COLUMNS   COLUMNS
#else
#  define LINES         (VWork.lines)
#  define COLUMNS       (VWork.columns)
#  define MAX_COLUMNS   160
#  define MAX_LINES     60
#endif

#define DEVICES     (LASTDEV-FIRSTDEV+1)
#define SIZES       (LASTSIZ-FIRSTSIZ+1)
#define DNAMELEN    (16)

/* Definitions for GEM events. */

#ifndef WF_BOTTOM
#define WF_BOTTOM	(25)
#endif
#ifndef WF_ICONIFY
#define WF_ICONIFY	(26)
#endif
#ifndef WF_UNICONIFY
#define WF_UNICONIFY	(27)
#endif

#ifndef WM_UNTOPPED
#define WM_UNTOPPED	(30)
#endif
#ifndef WM_ONTOP
#define WM_ONTOP	(31)
#endif
#ifndef WM_BOTTOMED
#define WM_BOTTOMED	(33)		/*      window backdrop */
#endif
#ifndef WM_ICONIFY
#define WM_ICONIFY	(34)		/* 	window -> icon */
#endif
#ifndef WM_UNICONIFY
#define WM_UNICONIFY	(35)		/*	icon -> window */
#endif
#ifndef WM_ALLICONIFY
#define WM_ALLICONIFY   (36)
#endif

#ifndef SMALLER
#define SMALLER		(0x4000)	/* CF : Iconify with MultiTOS */
#endif

#ifndef WC_BORDER
#define WC_BORDER 0
#endif
#ifndef WC_WORK
#define WC_WORK 1
#endif

#define COMMAND		(100)		/* New message type. */
#define PGFILTER	(110)		/* New message type. */
#define PGSELECT	(120)		/* New message type. */

/* Miscellaneous definitions. */

#define UL		(unsigned long)
#define ON		(1)
#define OFF		(0)
#define MAXTITLE        (32)
#define MAXLEN		(256)
#define DIRT_RECT 	(0)	/* Redraw only the dirty part of the window. */
#define FULL_WIN  	(1)	/* Redraw the full window. */
#define DEFINED_INTENSITY	(0)

/* Default filenames. */

#define CONFIGFILE	"stgs.rc"
#define CONFIGBAK	"stgs.bak"
#define PROLOG		"gs_pro.ps"
#define PAGE_PREFIX	"gs_pg"

#define OPENHELP	"open"
#define PAGHELP		"page"
#define OUTHELP		"print"
#define LOADHELP	"load"
#define SAVEHELP	"save"
#define PREVHELP	"prev"
#define NEXTHELP	"next"
#define DEVHELP		"dev"
#define RESHELP		"res"
#define SIZHELP		"size"
#define PAUSEHELP	"nopause"
#define PSFHELP		"pshelp"
#define MANAGHELP       "imanager"
#define ICONHELP	"icon"
#define CYCLEHELP	"cycle"
#define CLOSEHELP	"close"
#define COPYHELP	"copy"

#define GENHELP		"general"
#define FONTHELP	"font"
#define ERRHELP		"error"
#define FEATHELP	"feature"

/* Window Titles */

#define B_TITL (char *)" GS Image "
#define C_TITL (char *)" GS Image Copy "
#define T_TITL (char *)" GS Console "
#define I_TITL (char *)" GS "
#define A_TITL (char *)" GS Information "
#define R_TITL (char *)" GS Pixels/Inch "
#define D_TITL (char *)" GS Device "
#define S_TITL (char *)" GS Page Size "
#define H_TITL (char *)" GS Help "
#define O_TITL (char *)" GS Print "
#define P_TITL (char *)" GS Pages "

/* Window Gadgets. */

#define B_GADGETS (NAME+CLOSER+MOVER+SIZER+FULLER+VSLIDE\
		    +HSLIDE+UPARROW+DNARROW+LFARROW+RTARROW)
#define C_GADGETS (NAME+CLOSER+MOVER+SIZER+FULLER+VSLIDE\
		    +HSLIDE+UPARROW+DNARROW+LFARROW+RTARROW)
#define T_GADGETS (NAME+MOVER+SIZER+FULLER+VSLIDE\
		    +HSLIDE+UPARROW+DNARROW+LFARROW+RTARROW)
#define I_GADGETS (NAME+MOVER+FULLER)
#define A_GADGETS (CLOSER+NAME+MOVER)
#define R_GADGETS (CLOSER+NAME+MOVER)
#define D_GADGETS (CLOSER+NAME+MOVER)
#define S_GADGETS (CLOSER+NAME+MOVER)
#define O_GADGETS (CLOSER+NAME+MOVER)
#define P_GADGETS (CLOSER+NAME+MOVER)
#define H_GADGETS (NAME+CLOSER+MOVER+SIZER+FULLER+VSLIDE\
		    +HSLIDE+UPARROW+DNARROW+LFARROW+RTARROW)

/* Macros for the colorinfo structure. */

#define DITH_GRAY(depth)\
  (depth == 24 ? 195840 : depth == 16 ? 1535 : depth == 8 ? 39 :\
   depth == 4 ? 7 : depth == 2 ? 2 : 1)
#define DITH_RGB(depth)\
  (depth == 24 ? 256 : depth == 16 ? 40 : depth == 8 ? 6 :\
   depth == 4 ? 2 : depth == 2 ? 2 : 1)

/* Structure for cookie jar entries. */

typedef struct {
  long id;
  long value;
} COOKIE;

/* Structure for the characteristics of a virtual workstation. */

typedef struct vwrk {
    int VdiHandle;		/* vdi workstation handle */
    int XRes;			/* x resolution of screen in pixels */
    int YRes;			/* y resolution of screen in pixels */
    double AspectRatio;		/* the aspect ratio */
    GRECT full;			/* x, y, w, and h for the full screen */
    int ColorBits;		/* number of bit which represent a color */
    unsigned short MaxRGB;	/* maximum number of displayable colors */
    short TrueColor;		/* truecolor mode? */
    uint PaletteSize;		/* size of the palette */
    short GSPalette;		/* was palette installed by GS */
    int *Palette;		/* pointer to Ghostscript's palette */
    int *OldPalette;		/* pointer to the system palette */
    int *ColorReg;		/* array containing the color register
				   corresponding to a given vdi index */
    int Wchar;			/* Character cell width */
    int Hchar;			/* Character cell height */
    int Wbox;			/* Character box width */
    int Hbox;			/* Character box height */
#if !FIXED_CONSOLE_SIZE
    int lines, columns; /* height and width of console window */
#endif
} VWRK;

/* Structure describing a GEM event. */

typedef struct event {
    int WaitEvent;		/* which events to wait for */
    int Event;			/* the current event */
    int Message[8];		/* receive message buffer */
    ushort SendMsg[8];		/* send message buffer */
    int WaitButtonState;	/* which button state to wait for */
    int ButtonState;		/* button state at time of event */
    int Clicks;			/* Number of clicks detected */
    int MouseX;			/* mouse x position at time of event */
    int MouseY;			/* mouse y position at time of event */
    int KeyState;		/* keyboard state at time of event */
    int Key;			/* the key which was pressed */
    int KeyMenu;		/* keyboard equivalent of a menu event */
    int KeyScroll;		/* keyboard equivalent of a scroll event */
} EVENT;

#define DEFINE_EVENT {\
    0,				/* WaitEvent */\
    0,				/* Event */\
    {0, 0, 0, 0, 0, 0, 0, 0},	/* Message[] */\
    {0, 0, 0, 0, 0, 0, 0, 0},	/* SendMsg[] */\
    0,				/* WaitButtonState */\
    0,  			/* ButtonState */\
    0,  			/* Clicks */\
    0,				/* MouseX */\
    0,  			/* MouseY */\
    0,  			/* KeyState */\
    0,  			/* Key */\
    0,				/* KeyMenu */\
    -1				/* KeyScroll */\
}

/* Structure describing an individual page from a PostScript document. */

typedef struct pageinfo {
    short extracted;
    fpos_t start;
    int	   length;
} PAGEINFO;

/* Structure describing a PostScript document. */

typedef struct document {
    char name[MAXLEN];
    int maxpages;
    int numpages;
    int currentpage;
    PAGEINFO *pageinf;
} DOCUMENT;

/* Structure for the Ghostscript program state. */

typedef struct pstate {
    short ApId;			/* the GEM id for this application */
    short MultiTOS;		/* MultiTOS true if > 1 process allowed */
    short HasIconifier;	        /* SMALLER gadget is available */
    short IconManager;          /* use the built-in icon manager */
    short Windows;		/* are windows enabled? */
    int   TopWin;		/* Handle of top window. */
    short PSHelp;		/* use PostScript formatted help */
    short SelectPages;		/* filter individual pages from input file */
    short Device;               /* the current output device type */
    short LastDevice;           /* the last active device type */
    char CurrentDir[MAXLEN];	/* the current directory */
    char DirSpec[MAXLEN];	/* dir selected with file selector */
    char FileSel[MAXLEN];	/* file selected with the file selector */
    char InDir[MAXLEN];         /* input file directory */
    char OutDir[MAXLEN];        /* output file directory */
    char Infile[MAXLEN];	/* input file name */
    char Outfile[MAXLEN];	/* output file name */
    char Command[MAXLEN];	/* string for Ghostscript command */
    char DevString[MAXLEN];	/* the name of the current device */
    int PaletteCount;		/* # of palette entries which have been set */
    short Chunky8;		/* flag indicating 8-bit chunky image format */
    short Gdebug;		/* debug flag */
    short Debug8;		/* when set, forces GS to use 8-bit color */
    short Debug16;		/* when set, forces GS to use 16-bit color */
    int pxy[8];			/* array for general x,y coodinates */
    EVENT *Event;		/* the current event */
    DOCUMENT *Doc;		/* structure describing the current document */
} PSTATE;

/* Structure describing the bitmap images created by GS */

typedef struct graphic {
    int PlotX;			/* x position of upper left corner of image */
    int PlotY;			/* y position of upper left corner of image */
    int XRes;			/* x pixels per inch */
    int YRes;			/* y pixels per inch */
    int Width;			/* width of image */
    int Height;			/* height of image */
    int StepX;			/* x increment cursor keys will move image */
    int StepY;			/* y increment cursor keys will move image */
    MFDB image;			/* MFDB describing the bitmap image */
    MFDB screen;		/* MFDB describing the screen */
} GRAPHIC;

/* General window structure. */

typedef struct window {
    short handle;	/* window handle */
    short type;		/* type of window (TEXT, OBJ, BIT) */
    void  *obj;		/* pointer to object contained in window */
    short gadgets;	/* which window gadgets are enabled */
    char  *title;	/* pointer to window title */
    short opened;	/* flag for window state */
    short iconified;	/* true if iconified */
    GRECT canvas;	/* size of window work area */
    GRECT frame;	/* sized of entire window */
    GRECT oframe;	/* last frame size */
    GRECT mframe;	/* maximum frame size */
#define WREDRAW_FUNC(name) void name(int, PSTATE *)
    WREDRAW_FUNC((*redraw));	/* routine for window redraw */
#define WMOVE_FUNC(name) void name(PSTATE *)
    WMOVE_FUNC((*move));	/* routine for window move */
#define WSIZE_FUNC(name) void name(PSTATE *)
    WSIZE_FUNC((*size));	/* routine for window resize */
#define WARROW_FUNC(name) void name(PSTATE *)
    WARROW_FUNC((*arrow));	/* routine for window arrows */
#define WSLIDE_FUNC(name) void name(PSTATE *)
    WSLIDE_FUNC((*hslide));	/* routine for horizontal slider */
    WSLIDE_FUNC((*vslide));	/* routine for vertical slider */
#define WKEYBD_FUNC(name) int name(PSTATE *)
    WKEYBD_FUNC((*keybd));    /* routine for keyboard event */
#define WBUTTON_FUNC(name) int name(OBJECT[], int, struct window *, VWRK *, PSTATE *, GRAPHIC *, stream_cursor_write *, byte **)
    WBUTTON_FUNC((*button));	/* routine for button event */
} WINDOW;

#define DEFINE_TEXTWIN(obj, gadgets, title, keybd, button) {\
    -1,\
    TEXT,\
    obj,\
    gadgets,\
    title,\
    0,\
    0,\
    {0, 0, 0, 0},\
    {0, 0, 0, 0},\
    {0, 0, 0, 0},\
    {0, 0, 0, 0},\
    txtw_redraw,\
    txtw_move,\
    txtw_size,\
    txtw_arrow,\
    txtw_hslide,\
    txtw_vslide,\
    keybd,\
    button\
}

#define DEFINE_OBJWIN(obj, gadgets, title, keybd, button) {\
    -1,\
    OBJ,\
    obj,\
    gadgets,\
    title,\
    0,\
    0,\
    {0, 0, 0, 0},\
    {0, 0, 0, 0},\
    {0, 0, 0, 0},\
    {0, 0, 0, 0},\
    objw_redraw,\
    objw_move,\
    NULL,\
    NULL,\
    NULL,\
    NULL,\
    keybd,\
    button\
}

#define DEFINE_BITWIN(obj, gadgets, title, keybd, button) {\
    -1,\
    BIT,\
    obj,\
    gadgets,\
    title,\
    0,\
    0,\
    {0, 0, 0, 0},\
    {0, 0, 0, 0},\
    {0, 0, 0, 0},\
    {0, 0, 0, 0},\
    bitw_redraw,\
    bitw_move,\
    bitw_size,\
    bitw_arrow,\
    bitw_hslide,\
    bitw_vslide,\
    keybd,\
    button\
}

/* Structure for connecting windows in a double-linked list. */

typedef struct WinList {
    WINDOW *Win;
    struct WinList *Prev;
    struct WinList *Next;
} WINLIST;

/* Structure for text in windows. */

typedef struct wintext {
#if FIXED_CONSOLE_SIZE
    char   (*buff)[COLUMNS+1];	/* text buffer */
#else
    char   *buff;	/* text buffer */
#endif
    int	   bsize;	/* buffer size in lines of length COLUMNS+1. */
    int    bw, bh;	/* width and height of the used buffer. */
    int    top;		/* position of the top of page wrt screen */
    int    edge;	/* position of the left edge of page wrt screen */
    int    cx, cy;	/* cursor position in raster coordinates */
    short  xoff, yoff;	/* offset of text wrt top left corner of page */
    short  cstate;	/* cursor state (on/off) */
    short  wc, hc;	/* width and height of the character in current font */
    short  lins, cols;	/* width and height of the textwin in characters */
    short  ln, cn;	/* the current line and column */
    short  fl, ll;	/* first and last lines in the text buffer */
    short  fdl, ldl;	/* first and last displayed lines */
    short  fdc, ldc;	/* first and last displayed columns */
    short  scrolled;	/* state of scrolling */
} WINTEXT;

#if FIXED_CONSOLE_SIZE
#define TEXTLINE(text, line) \
	((text)->buff[line])

#define DEFINE_WINTEXT {\
    0,\
    0,\
    COLUMNS+1, LINES,\
    0,\
    0,\
    0, 0,\
    0, 0,\
    0,\
    0, 0,\
    0, 0,\
    0, 0,\
    0, LINES-1,\
    0, LINES-1,\
    0, 0,\
    0\
}

#else

#define TEXTLINE(text, line) \
	(&(text)->buff[(line) * (COLUMNS+1)])
#endif

#endif /* st_defs_h_INCLUDED */

/* end ataridef.h */
