/* Copyright (C) 1989, 1992, 1993 Aladdin Enterprises.  All rights reserved.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gp_atar4.h */

/* Ghostscript header file for the Atari platform. */

/*
 * Memory allocation for various data structures.
 */

extern WINDOW *WinAlloc(void);
extern void WinFree(WINDOW *);

extern WINTEXT *WinTextAlloc(int);
extern void WinTextFree(WINTEXT *);

#if FIXED_CONSOLE_SIZE
extern char (*TextBuffRealloc(WINTEXT *, int))[COLUMNS+1];
#else
extern char *TextBuffRealloc(WINTEXT *, int);
#endif

extern GRAPHIC *GraphicAlloc(void);
extern void GraphicFree(GRAPHIC *);
extern void BitBufferFree(GRAPHIC *);

extern WINLIST *WinListAlloc(void);
extern void WinListFree(WINLIST *);

extern void WinTitleFree(char *);

extern OBJECT *CreatePageObj(int);
extern int DeletePageObj(PSTATE *, WINDOW *);

extern OBJECT *CreateIconListObj(void);

extern void IconListFree(OBJECT *);
extern void UpdateIconList(OBJECT *, VWRK *);
extern void UpdateIconObj(OBJECT *, VWRK *);

/*
 * Utility functions.
 */

extern void AssignObj(OBJECT *, int, int, int, int, int, int,
		      unsigned long, int, int, int, int);
extern void AssignTinf(TEDINFO *, char *, const char *, const char *,
		       int, int, int, int, int, int, int, int);

extern int PageFilter(char *, DOCUMENT *);
extern int PageCopy(int, char *, DOCUMENT *);

extern void MenuWrite(PSTATE *, int, int);
extern bool MenuSearch(PSTATE *, OBJECT *);
extern int GetFile(PSTATE *, const char *);
extern int SendCommand(PSTATE *, stream_cursor_write *, byte **);

extern void GetPalette(int *, VWRK *);
extern void SetPalette(int *, VWRK *);

extern void SetWinPosition(WINDOW *, VWRK *, PSTATE *, double, double);
extern void SetWinFrame(WINDOW *, VWRK *, PSTATE *, double, double,
			double, double);

extern int LoadConfig(VWRK *, PSTATE *);
extern int SaveConfig(VWRK *, PSTATE *);

extern int align(int);
extern int nint(double);
extern void *ObjFindH(int);
extern void RestoreBG(VWRK *);
extern char *itoa(int, char *);
extern void DevObjUpdate(PSTATE *);
extern int FormAlert(int, const char *);
extern char *presub(char *, const char *);
extern int CopyImage(GRAPHIC *, VWRK *, PSTATE *);
extern void ObjcDraw(OBJECT *, int, int, WINDOW *);
extern int ApplGetinfo(int, int *, int *, int *, int *);
extern void ObjcChange(OBJECT *, int, int, WINDOW *, int, int);
extern const char *PathFind(const char *, const char *, const char *);

/* end gp_atar4.h */




