/* Copyright (C) 1991 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gdevslm.c */

/* SLM 804 driver for the Atari ST. This driver was hacked
 * from the 'stmono' device with the aid of code originally written
 * by Hauke Hess and Tim Gallivan.   Robert Stabl 9/2/91
 */

#include <stdio.h>
#include <osbind.h>
#include "gdevprn.h"

/* Define the default device parameters. */

#ifndef X_DPI
#define X_DPI 300
#endif
#ifndef Y_DPI
#define Y_DPI 300
#endif
#define WIDTH_10THS 85
#define HEIGHT_10THS 110

private dev_proc_print_page(slm_print_page);

gx_device_printer gs_slm_device =
  prn_device(prn_std_procs, "slm",
	WIDTH_10THS, HEIGHT_10THS,
	X_DPI, Y_DPI,
	0,0,0,0,			/* margins */
	1, slm_print_page);

/* Structure for the Diablo emulator (Atari SLM 804)
*/

typedef struct {
  char *s_form;
  short s_xmin,
        s_ymin,
        s_nxln,
        b_width,
        b_height,
        d_xmin,
        d_ymin,
        scalefac;
} SLM;

private int
slm_print_page(gx_device_printer *dev, FILE *dummy)
{
	/*  scanbuf = buffer for a scan line,
	 *  slmbuf  = buffer for entire image,
	 *  scanptr = long pointer to scan buffer,
	 *  slmptr  = long pointer to slm buffer.
	 */

	byte *scanbuf, *slmbuf;
	long *scanptr, *slmptr;

	/*  byte_width = width of scan line rounded up to nearest 4 bytes,
	 *  x_res_slm  = width of image in longs,
	 *  y_res_slm  = height of image in lines.
	 */

	int byte_width, x_res_slm, y_res_slm;
	int line, count, sizlong;

	FILE *fp;
	SLM o;

	sizlong = sizeof(long);

	byte_width = gdev_mem_bytes_per_scan_line((gx_device *)dev);
	x_res_slm  = (byte_width + sizlong - 1) / sizlong;
	byte_width = x_res_slm * sizlong;
	y_res_slm  = prn_dev->height;

	/* Allocate a buffer for a single scan line. */

	if ((scanbuf = (byte *)gs_malloc((uint)(byte_width), 1,
		"line buffer")) == NULL) {
		dprintf("gdevslm: Could not allocate memory for a line buffer!");
		return(-1);
	}
		
	/* Allocate a buffer for the printer bitmap. */

	if ((slmbuf = (byte *)gs_malloc((uint)(byte_width * y_res_slm), 1,
		"image buffer")) == NULL) {
		dprintf("gdevslm: Could not allocate memory for an image buffer!");
		return(-1);
	}
		
	scanptr = (long *)scanbuf;
	slmptr =  (long *)slmbuf;

	o.s_form   =     (char *)slmbuf;
	o.s_xmin   =     (short)0;
	o.s_ymin   =     (short)0;
  	o.s_nxln   =     (short)(byte_width);
  	o.b_width  =     (short)(prn_dev->width);
  	o.b_height =     (short)(prn_dev->height);
  	o.d_xmin   =     (short)0;
  	o.d_ymin   =     (short)0;
  	o.scalefac =     (short)1;

	/* Copy the bitmap to the slm buffer, one scan line at a time.
	 * Scan lines are copied as longs rather than bytes (for speed?).
	 */

	for (line = 0; line < y_res_slm; line++) {

		/* Copy (line)th scan line to scanbuf. */

		gdev_prn_copy_scan_lines(prn_dev, line
				       , scanbuf, byte_width);

		/* Copy scanbuf to the slm buffer. */

		for (count = 0; count < x_res_slm; count++ )
			*slmptr++ = scanptr[count];

	}

	fp = fopen("PRN:", "w");

	/* Send the image directly to the printer. */

  	fprintf(fp, "\033\022G%08lx \n\f", &o);

  	fclose(fp);
	
	gs_free((char *)scanbuf, byte_width, 1, "line buffer");
	gs_free((char *)slmbuf, byte_width * y_res_slm, 1, "image buffer");

	return (0);

}
