/* Copyright (C) 1989, 1992, 1993 Aladdin Enterprises.  All rights reserved.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gp_atar3.h */

/* Ghostscript header file for the Atari platform. */

extern int LastPrnOutButton;

/*
 * Callback functions for the window structure.
 */

extern WREDRAW_FUNC(txtw_redraw);
extern WREDRAW_FUNC(objw_redraw);
extern WREDRAW_FUNC(bitw_redraw);

extern WMOVE_FUNC(txtw_move);
extern WMOVE_FUNC(objw_move);
extern WMOVE_FUNC(bitw_move);

extern WSIZE_FUNC(txtw_size);
extern WSIZE_FUNC(bitw_size);

extern WARROW_FUNC(txtw_arrow);
extern WARROW_FUNC(bitw_arrow);

extern WSLIDE_FUNC(txtw_hslide);
extern WSLIDE_FUNC(bitw_hslide);

extern WSLIDE_FUNC(txtw_vslide);
extern WSLIDE_FUNC(bitw_vslide);

extern WBUTTON_FUNC(abo_button);
extern WBUTTON_FUNC(res_button);
extern WBUTTON_FUNC(dev_button);
extern WBUTTON_FUNC(siz_button);
extern WBUTTON_FUNC(ico_button);
extern WBUTTON_FUNC(prn_button);
extern WBUTTON_FUNC(pag_button);
extern WBUTTON_FUNC(ign_button);

/*
 * Window manipulation functions.
 */

extern void TextWinInit(WINDOW *, WINTEXT *, int, char *);
extern void BitWinInit(WINDOW *, GRAPHIC *, int, char *);
extern void ObjWinInit(WINDOW *, OBJECT *, int, char *);

extern int BitWinOpen(WINDOW *, VWRK *, PSTATE *);
extern int HelpWinOpen(VWRK *, PSTATE *, char *);
extern int TextWinOpen(WINDOW *, VWRK *, PSTATE *);
extern int ObjWinOpen(OBJECT[], WINDOW *, VWRK *, PSTATE *);

extern int WinClose(WINDOW *);
extern int UpdateScroll(int);

extern WINDOW *WinFindXY(int, int);
extern WINDOW *WinFindH(int);

extern WINLIST *WinListAdd(WINLIST *, WINDOW *);
extern WINLIST *WinListDelete(WINLIST *, WINDOW *);

extern void WinListOpen(WINLIST *);
extern void WinListClose(WINLIST *);
extern void WinListRedraw(WINLIST *, PSTATE *);

extern void EnforceLimits(GRECT *, VWRK *);
extern void MoveIntoLimits(GRECT *, VWRK *);

/* Real versions of the following functions are needed in gp_atar3. */

#undef fputc
#undef fputs
#undef fwrite

/* end gp_atar3.h */
