	/*X, Y, Z, Time, and Intensity = The universe as we perceive it.
     (I guess ). Not all of the objects described are visible from
     the current viewpoint, but they will be when I do the animation.*/

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "bell.inc" 
#include "xyz.inc"
#include "hours.inc"

camera {
   location  <0, 1, -16>
   direction <0, 0, 1>
   up        <0, 1, 0>
   right     <4/3, 0, 0>
   look_at   <0, 0, 0>
   }

light_source { <80, 60, -20> color White }

light_source { <-80, 20, -20> color DarkPurple }

light_source { <-10, 10, -9> color White }

cylinder { <0, -6.75, 0> <0, -7.05, 0> 3
   texture { Jade finish { reflection 0.8
                           ambient 0.1
                           diffuse 0.6
                           phong 1 phong_size 80}}  
   scale <4, 1, 4>
}

//Purple reflection source

plane { z, -2010//The year we make contact
   pigment { color red 0.3 green 0.1 blue 0.3 }
   finish { ambient 0.75 diffuse 0.5 }
}   


#declare Clock_Body =
   object {
   union {
   object { //Main clock body
   cylinder { <0, 0, 1> <0, 0, 0.5> 2 open
     texture { Polished_Brass }}
}
   object { 
   torus { 1.5, 0.5 //Rounded back corners
     rotate <90, 0, 0> translate <0, 0, 0.5>
     texture { Polished_Brass }}
}
   object { //Back of clock
   cylinder { <0, 0, 0.75> <0, 0, 1> 1.5
     texture { Polished_Brass }}
}
   object {
   cone { <0, 0, -1> 2  <0, 0, -1.5> 2.25 open
     texture { Polished_Brass }}
}
   object {
   cone { <0, 0, -1>1.75 <0, 0, -1.5> 2 open
     texture { Polished_Brass }}
}
   object {
   torus { 2.125, 0.125 
     rotate <90, 0, 0> translate <0, 0, -1.5>
     texture { Polished_Brass }}
}
   object {
   torus { 1.75, 0.0625
     rotate <90, 0, 0> translate <0, 0, -1>
     texture { Polished_Brass }}
}
   object { //Clock face
   cylinder { <0, 0, -1> <0, 0, -0.5> 1.75
     texture { White_Marble }
     finish { reflection 0.0 ambient 0.2 diffuse 0.6}
     }
}
   

   object { Bell rotate <0, 0, 30> }

   object { Bell rotate <0, 0, -30> }
   
   object { Ringer }}
}       
    
   object {
   union {
   object {
     Clock_Body  }
   object {
     Time } scale <2, 2, 2> }
}

   object { X_Coord translate <5.5, 0, -4.9> }

   object { Y_Coord translate <0, 4.5, -4.9>}

   object {
   union {
   object  { Z_Coord translate <0, 0, -12>}
     object {
       cylinder { <0, 0, -50> <0, 0,-1> 0.125
       texture { Polished_Brass }}
         }}
}
//negative symbol for Z_Coord
   object {
   union {
   object {
     sphere { <-2, 0, -12> 0.125
     pigment { color Blue }
     finish { Nifty }}
}
   object {
     cylinder { <-2, 0, -12> <-1, 0, -12> 0.125
     pigment { color Blue }
     finish { Nifty }}
}
   object {
     sphere { <-1, 0, -12> 0.125
     pigment { color Blue }
     finish { Nifty }}
     }}
}

/*The Earth in the background is not part of this data set,
  it's a copied and pasted bitmap from a previous trace (EARTHB.GIF).*/