/*********************************************************************
							LEGOKA.POV

Usage:  A Persistence of Vision 2.0 scene file. See also LEGOBITS.INC,
		which provides the construction units from which the LEGO
		objects are constructed. This scene file makes no use of the
		standard POV include files, so it may be of interest if you
		are looking for a fairly self-contained tutorial example.

Author: Peter Middlestorb
		CIS:100065,3267
		May 1994

Status: Public domain. Fold, spindle or mutilate as you see fit.

Acknowledgements:

		LEGO is a registered trademark of LEGO Group.
		Much kudos to the POV-Ray Team for producing the excellent
		and freely available Persistence of Vision Raytracer.
*********************************************************************/

/*********************************************************************
include
*********************************************************************/
#include "legobits.inc"

/*********************************************************************
texture, finish and color declarations
*********************************************************************/

//========== pigment for desktop ==========
#declare pigDesktop = pigment {
	wood
	turbulence 0.2
	color_map {
		[0.0, 0.2   color red 0.7 green 0.23333 blue 0.11666
					color red 0.6 green 0.20000 blue 0.10000]
		[0.2, 0.7   color red 0.6 green 0.20000 blue 0.10000
					color red 0.7 green 0.23333 blue 0.11666]
		[0.7, 0.8   color red 0.7 green 0.23333 blue 0.11666
					color red 0.4 green 0.13333 blue 0.06666]
		[0.8, 1.0   color red 0.4 green 0.13333 blue 0.06666
					color red 0.2 green 0.06666 blue 0.03333]
	}
}

//========== colours for graph paper ==========
#declare colSheet = color red 0.95 green 0.95 blue 0.8
#declare colGrid = color red 0.0 green 0.4 blue 0.0
#declare colLead = color red 0.25 green 0.25 blue 0.25

//========== colour, pigment and texture for drawing implements ==========
#declare pigPencil = pigment {
	wood
	turbulence 0.1
	color_map {
		[0.0, 0.7   color red 0.9 green 0.36 blue 0.18
					color red 0.9 green 0.36 blue 0.18]
		[0.7, 1.0   color red 0.6 green 0.20 blue 0.10
					color red 0.6 green 0.20 blue 0.10]
	}
	rotate <0, 90, 0>
	scale <0.8, 0.8, 0.8>
}

#declare texPencil = texture {
	pigment {pigPencil}
	finish {
		brilliance 2.0
		phong 0.8
		phong_size 80
	}
}

#declare colEraser = color red 0.2 green 0.65 blue 0.2

//========== plastic finishes ==========
#declare finShinyPlastic = finish {
	brilliance 3.0
	reflection 0.15
	phong 1.0
	phong_size 130
}

#declare finMattPlastic = finish {
	brilliance 2.0
	phong 1.0
	phong_size 130
}

//========== plastics for car ==========
#declare texShinyRedPlastic = texture {
	pigment {color red 1.7 green 0.0 blue 0.0}  // note "unnatural" value
	finish {finShinyPlastic}
}

#declare texShinyYellowPlastic = texture {
	pigment {color red 1.6 green 1.6 blue 0.0}  // note "unnatural" value
	finish {finShinyPlastic}
}

#declare texShinyGreyPlastic = texture {
	pigment {color red 0.98 green 0.98 blue 0.98}
	finish {finShinyPlastic}
}

#declare texMattGreyPlastic = texture {
	pigment {color red 0.98 green 0.98 blue 0.98}
	finish {finMattPlastic}
}

#declare texShinyBlackPlastic = texture {
	pigment {color red 0.3 green 0.3 blue 0.3}
	finish {finShinyPlastic}
}

#declare texMattBlackPlastic = texture {
	pigment {color red 0.3 green 0.3 blue 0.3}
	finish {finMattPlastic}
}

//========== working colours - declared as needed ==========
#declare colWhite = color red 1.0 green 1.0 blue 1.0
#declare colGreen = color green 1.0
#declare colBlue = color blue 1.0

/*********************************************************************
graph paper sub-assemblies
*********************************************************************/

//========== A4 sheet ==========
#declare objSheet = difference {
	box {<0.0, 0.0, 0.0> <210.0, 0.1, 297.0>}
	cylinder {<12.0, -0.1, 107.0>, <12.0, 0.2, 107.0> 3.0}
	cylinder {<12.0, -0.1, 187.0>, <12.0, 0.2, 187.0> 3.0}
}

//========== grid for A4 10mm graph paper ==========
#declare objGrid = union {
	box {<20.0, 0.1,  10.0> <200.3, 0.11,  10.3>}
	box {<20.0, 0.1,  20.0> <200.3, 0.11,  20.3>}
	box {<20.0, 0.1,  30.0> <200.3, 0.11,  30.3>}
	box {<20.0, 0.1,  40.0> <200.3, 0.11,  40.3>}
	box {<20.0, 0.1,  50.0> <200.3, 0.11,  50.3>}
	box {<20.0, 0.1,  60.0> <200.3, 0.11,  60.3>}
	box {<20.0, 0.1,  70.0> <200.3, 0.11,  70.3>}
	box {<20.0, 0.1,  80.0> <200.3, 0.11,  80.3>}
	box {<20.0, 0.1,  90.0> <200.3, 0.11,  90.3>}
	box {<20.0, 0.1, 100.0> <200.3, 0.11, 100.3>}
	box {<20.0, 0.1, 110.0> <200.3, 0.11, 110.3>}
	box {<20.0, 0.1, 120.0> <200.3, 0.11, 120.3>}
	box {<20.0, 0.1, 130.0> <200.3, 0.11, 130.3>}
	box {<20.0, 0.1, 140.0> <200.3, 0.11, 140.3>}
	box {<20.0, 0.1, 150.0> <200.3, 0.11, 150.3>}
	box {<20.0, 0.1, 160.0> <200.3, 0.11, 160.3>}
	box {<20.0, 0.1, 170.0> <200.3, 0.11, 170.3>}
	box {<20.0, 0.1, 180.0> <200.3, 0.11, 180.3>}
	box {<20.0, 0.1, 190.0> <200.3, 0.11, 190.3>}
	box {<20.0, 0.1, 200.0> <200.3, 0.11, 200.3>}
	box {<20.0, 0.1, 210.0> <200.3, 0.11, 210.3>}
	box {<20.0, 0.1, 220.0> <200.3, 0.11, 220.3>}
	box {<20.0, 0.1, 230.0> <200.3, 0.11, 230.3>}
	box {<20.0, 0.1, 240.0> <200.3, 0.11, 240.3>}
	box {<20.0, 0.1, 250.0> <200.3, 0.11, 250.3>}
	box {<20.0, 0.1, 260.0> <200.3, 0.11, 260.3>}
	box {<20.0, 0.1, 270.0> <200.3, 0.11, 270.3>}
	box {<20.0, 0.1, 280.0> <200.3, 0.11, 280.3>}
	box {< 20.0, 0.1, 10.0> < 20.3, 0.11, 280.3>}
	box {< 30.0, 0.1, 10.0> < 30.3, 0.11, 280.3>}
	box {< 40.0, 0.1, 10.0> < 40.3, 0.11, 280.3>}
	box {< 50.0, 0.1, 10.0> < 50.3, 0.11, 280.3>}
	box {< 60.0, 0.1, 10.0> < 60.3, 0.11, 280.3>}
	box {< 70.0, 0.1, 10.0> < 70.3, 0.11, 280.3>}
	box {< 80.0, 0.1, 10.0> < 80.3, 0.11, 280.3>}
	box {< 90.0, 0.1, 10.0> < 90.3, 0.11, 280.3>}
	box {<100.0, 0.1, 10.0> <100.3, 0.11, 280.3>}
	box {<110.0, 0.1, 10.0> <110.3, 0.11, 280.3>}
	box {<120.0, 0.1, 10.0> <120.3, 0.11, 280.3>}
	box {<130.0, 0.1, 10.0> <130.3, 0.11, 280.3>}
	box {<140.0, 0.1, 10.0> <140.3, 0.11, 280.3>}
	box {<150.0, 0.1, 10.0> <150.3, 0.11, 280.3>}
	box {<160.0, 0.1, 10.0> <160.3, 0.11, 280.3>}
	box {<170.0, 0.1, 10.0> <170.3, 0.11, 280.3>}
	box {<180.0, 0.1, 10.0> <180.3, 0.11, 280.3>}
	box {<190.0, 0.1, 10.0> <190.3, 0.11, 280.3>}
	box {<200.0, 0.1, 10.0> <200.3, 0.11, 280.3>}
}

//========== 2x1 block sketch (scale 2:1) ==========
#declare objSketchBlock2x1 = union {
	box {<-0.2, 0.1, -0.2> <32.2, 0.12,  0.2>}  // bottom
	box {<-0.2 ,0.1, -0.2> < 0.2 ,0.12, 19.4>}  // left
	box {<-0.2 ,0.1, 19.0> <32.2 ,0.12, 19.4>}  // top
	box {<31.8 ,0.1, -0.2> <32.2 ,0.12, 19.4>}  // right
	box {< 2.8 ,0.1, 19.0> < 3.2 ,0.12, 23.0>}  // left pip left
	box {< 2.8 ,0.1, 22.6> <13.2 ,0.12, 23.0>}  // left pip top
	box {<12.8 ,0.1, 19.0> <13.2 ,0.12, 23.0>}  // left pip right
	box {<18.8 ,0.1, 19.0> <19.2 ,0.12, 23.0>}  // right pip left
	box {<18.8 ,0.1, 22.6> <29.2 ,0.12, 23.0>}  // right pip top
	box {<28.8 ,0.1, 19.0> <29.2 ,0.12, 23.0>}  // right pip right
}                

#declare objSketchBlockOtrHole = difference {
	cylinder {<0.0, 0.1, 0.0> <0.0, 0.12, 0.0> 6.2}
	cylinder {<0.0, 0.0, 0.0> <0.0, 0.20, 0.0> 5.8}
}

#declare objSketchBlockInrHole = difference {
	cylinder {<0.0, 0.1, 0.0> <0.0, 0.12, 0.0> 5.0}
	cylinder {<0.0, 0.0, 0.0> <0.0, 0.20, 0.0> 4.6}
}

#declare objSketchHoleBlock2x1 = union {
	object {objSketchBlock2x1}
	object {objSketchBlockOtrHole
		translate <16.0, 0.0, 11.8>
	}
	object {objSketchBlockInrHole
		translate <16.0, 0.0, 11.8>
	}
}

//========== wheel sketch (scale 2:1) ==========
#declare objSketchWheelOuter = difference {
	cylinder {<0.0, 0.1, 0.0> <0.0, 0.12, 0.0> 17.2}
	cylinder {<0.0, 0.0, 0.0> <0.0, 0.20, 0.0> 16.8}
}

#declare objSketchWheelInner = difference {
	cylinder {<0.0, 0.1, 0.0> <0.0, 0.12, 0.0> 12.2}
	cylinder {<0.0, 0.0, 0.0> <0.0, 0.20, 0.0> 11.8}
}

#declare objSketchWheel = union {
	object {objSketchWheelOuter}
	object {objSketchWheelInner}
}

/*********************************************************************
drawing implements
*********************************************************************/

#declare objPencil = union {
	cone {<0.0, 0.0, 0.0>, 0.0, < 5.0, 0.0, 0.0>, 1.0
		pigment {color colLead}
	}
	cone {<5.0, 0.0, 0.0>, 1.0, <20.0, 0.0, 0.0>, 4.0
		pigment {pigPencil}             // only pigment where sharpened
	}
	cylinder {<20.0, 0.0, 0.0> <140, 0.0, 0.0> 4.0
		texture {texPencil}             // full texture where unsharpened
	}
}

#declare objEraser = difference {
	box {<0.0, 0.0, 0.0> <55.0, 8.0, 20.0>}
	plane {x, 0
		rotate <0, 0, -45>
	}
	plane {-x, 0
		rotate <0, 0, -45>
		translate <55.0, 8.0, 0.0>
	}
	pigment {color colEraser}
}

/*********************************************************************
car sub-assemblies
*********************************************************************/

//========== car body ==========
#declare objCarBody = union {
	object {objBlock2x1                 // rear right outer axle block
		texture {texShinyRedPlastic}
		translate <0.0, -3.2, 0.0>
	}
	object {objBlock2x1                 // rear right inner axle block
		texture {texShinyRedPlastic}
		translate <0.0, -3.2, 8.0>
	}
	object {objBlock2x1                 // rear left inner axle block
		texture {texShinyRedPlastic}
		translate <0.0, -3.2, 16.0>
	}
	object {objBlock2x1                 // rear left outer axle block
		texture {texShinyRedPlastic}
		translate <0.0, -3.2, 24.0>
	}
	object {objSlab4x2                  // rear axle block spacer
		texture {texShinyRedPlastic}
		rotate <0, -90, 0>
		translate <16.0, 6.4, 0.0>
	}
	object {objBlock6x1                 // right side pod
		texture {texShinyRedPlastic}
		translate <16.0, 0.0, 0.0>
	}
	object {objBlock16x1                // right rail
		texture {texShinyRedPlastic}
		translate <16.0, 0.0, 8.0>
	}
	object {objBlock16x1                // left rail
		texture {texShinyRedPlastic}
		translate <16.0, 0.0, 16.0>
	}
	object {objBlock6x1                 // left side pod
		texture {texShinyRedPlastic}
		translate <16.0, 0.0, 24.0>
	}
	object {objSlab8x2                  // top right tie plate
		texture {texShinyRedPlastic}
		translate <0.0, 9.6, 0.0>
	}
	object {objSlab8x2                  // top left tie plate
		texture {texShinyRedPlastic}
		translate <0.0, 9.6, 16.0>
	}
	object {objBlock2x1                 // right seat back block
		texture {texShinyRedPlastic}
		translate <0.0, 12.8, 8.0>
	}
	object {objBlock2x1                 // left back block
		texture {texShinyRedPlastic}
		translate <0.0, 12.8, 16.0>
	}
	object {objBlock2x1                 // parachute
		texture {texShinyYellowPlastic}
		rotate <0, -90, 0>
		translate <8.0, 22.4, 8.0>
	}
	object {objBlock2x1                 // headrest
		texture {texShinyRedPlastic}
		rotate <0, -90, 0>
		translate <16.0, 22.4, 8.0>
	}
	object {objBlock4x1                 // right engine block cylinders
		texture {texShinyGreyPlastic}
		translate <32.0, 12.8, 8.0>
	}
	object {objBlock4x1                 // left engine block cylinders
		texture {texShinyGreyPlastic}
		translate <32.0, 12.8, 16.0>
	}
}

//========== rear axle and wheels ==========
#declare objRearWheels = union
{
	object {objRodx6                    // rear axle
		texture {texMattBlackPlastic}
		rotate <0, -90, 0>
	}
	object {objWheel                    // right rear wheel
		texture {texMattGreyPlastic}
	}
	object {objLargeTyre                // right rear tyre
		texture {texShinyBlackPlastic}
		translate <0.0, 0.0, -3.6>
	}
	object {objWheel                    // left rear wheel
		texture {texMattGreyPlastic}
		translate <0.0, 0.0, 40.8>
	}
	object {objLargeTyre                // left rear tyre
		texture {texShinyBlackPlastic}
		rotate <0, 180, 0>
		translate <0.0, 0.0, 51.6>
	}
}

//========== front axle and wheels ==========
#declare objFrontWheels = union
{
	object {objRodx4                    // front axle
		texture {texMattBlackPlastic}
		rotate <0, -90, 0>
	}
	object {objWheel                    // right front wheel
		texture {texMattGreyPlastic}
	}
	object {objSmallTyre                // right front tyre
		texture {texShinyBlackPlastic}
	}
	object {objWheel                    // left front wheel
		texture {texMattGreyPlastic}
		translate <0.0, 0.0, 24.8>
	}
	object {objSmallTyre                // left front tyre
		texture {texShinyBlackPlastic}
		translate <0.0, 0.0, 24.8>
	}
}

//========== pair of exhaust venturi on linking pipe ==========
#declare objExhaustPair = union {
	object {objRodx4
		texture {texMattBlackPlastic}
		rotate <0, -90, 0>
		rotate <0, 0, 105>              // cant up and back to match exhausts
	}
	object {objRod90LockJoint
		texture {texMattGreyPlastic}
		rotate <0, 0, 105>              // cant from - to 15deg up and back
		translate <0.0, 0.0, 4.0>
	}
	object {objRod90LockJoint
		texture {texMattGreyPlastic}
		rotate <180, 0, 0>
		rotate <0, 0, 105>              // cant from - to 15deg up and back
		translate <0.0, 0.0, 28.0>
	}
}

//========== safety cage - inner ==========
#declare objCageInner = union { 
	object {objRodx4                    // seat base cage support
		texture {texMattBlackPlastic}
		rotate <0, -90, 0>
	}
	object {objRod90LockJoint           // join seat base and right support
		texture {texMattGreyPlastic}
		translate <0.0, 0.0, 4.0>
	}
	object {objRod90LockJoint           // join seat base and left support
		texture {texMattGreyPlastic}
		rotate <180, 0, 0>
		translate <0.0, 0.0, 28.0>
	}
	object {objRodx3                    // right support
		texture {texMattBlackPlastic}
		translate <4.0, 0.0, 4.0>
	}
	object {objRodx3                    // left support
		texture {texMattBlackPlastic}
		translate <4.0, 0.0, 28.0>
	}
	object {objRod90Joint               // right join for top rail (unlocked)
		texture {texMattGreyPlastic}
		rotate <0, 0, 180>
		rotate <180, 0, 0>
		translate <33.15650117, 0.0, 4.0>     // not quite seated on support
	}
	object {objRod90Joint               // left join for top rail (unlocked)
		texture {texMattGreyPlastic}
		rotate <0, 0, 180>
		translate <33.15650117, 0.0, 28.0>    // not quite seated on support
	}
	rotate <0, 0, 90>
}

//========== safety cage - outer ==========
#declare objCageOuter = union { 
	object {objRodx6                    // chassis cage support
		texture {texMattBlackPlastic}
		rotate <0, -90, 0>
	}
	object {objRod90LockJoint           // join chassis and right diagonal
		texture {texMattGreyPlastic}
		translate <0.0, 0.0, 4.0>
	}
	object {objRod90LockJoint           // join chassis and left diagonal
		texture {texMattGreyPlastic}
		rotate <180, 0, 0>
		translate <0.0, 0.0, 44.0>
	}
	object {objRodx6                    // right diagonal
		texture {texMattBlackPlastic}
		translate <4.0, 0.0, 4.0>
	}
	object {objRodx6                    // left diagonal
		texture {texMattBlackPlastic}
		translate <4.0, 0.0, 44.0>
	}
	object {objRod90LockJoint           // join chassis and right diagonal
		texture {texMattGreyPlastic}
		rotate <0, 0, 180>
		translate <56.0, 0.0, 4.0>
	}
	object {objRod90LockJoint           // join chassis and left diagonal
		texture {texMattGreyPlastic}
		rotate <0, 0, 180>
		rotate <180, 0, 0>
		translate <56.0, 0.0, 44.0>
	}
	object {objRodx6                    // top rail
		texture {texMattBlackPlastic}
		rotate <0, -90, 0>
		translate <56.0, 0.0, 0.0>
	}
	rotate <0, 0, 124.8499046>
}

/*********************************************************************
make car from sub-assemblies
*********************************************************************/

#declare objCar = union {
	object {objCarBody}
	object {objRearWheels
		rotate <0, 0, -70>              // rotate spokes out of x alignment
		translate <8.0, 2.7, -8.0>
	}
	object {objFrontWheels
		rotate <0, 0, 20>               // rotate spokes out of x alignment
		translate <136.0, 5.9, 0.0>
	}
	object {objExhaustPair              // rear set of exhausts
		translate <40.0, 18.7, 0.0>
	}
	object {objExhaustPair              // middle set of exhausts
		translate <48.0, 18.7, 0.0>
	}
	object {objExhaustPair              // font set of exhausts
		translate <56.0, 18.7, 0.0>
	}
	object {objCageInner                // inner cage assembly
		translate <8.0, 18.7, 0.0>
	}
	object {objCageOuter                // outer cage assembly
		translate <40.0, 5.9, -8.0>
	}
}

/*********************************************************************
observer and lights
*********************************************************************/

//========== the onlooker ==========
camera {
	location    <320, 380, -200>
	direction   <0, 0, 4.1>
	look_at     <123, 32, 163>
}

//========== lighting ==========
light_source {<-1500, 1500, -350>
	color colWhite
}
light_source {<2000, 1000, -150>
	color colWhite
}

/*********************************************************************
make the scene from the bits
*********************************************************************/

/*
//========== a diagnostic plane only used to check dimensions ==========
plane {y, 0
	texture {
		pigment {checker color colGreen color colBlue}
		scale <8, 8, 8>
	}
}
*/

//========== a cheap wooden desk top ==========
plane {y, 0
	texture {
		pigment {pigDesktop}
		rotate <0, 90, 0>
		scale <20, 1, 10>
	}
}

//========== lay the paper on the desktop ==========
object {objSheet
	pigment {color colSheet}
}

//========== drop the grid onto the paper ==========
object {objGrid
	pigment {color colGrid}
}

//========== put some sketches on the graph paper ==========
object {objSketchBlock2x1
	pigment {color colLead}
	translate <70, 0, 100>
}
object {objSketchHoleBlock2x1
	pigment {color colLead}
	rotate <0, -90, 0>
	translate <170, 0, 130>
}
object {objSketchWheel
	pigment {color colLead}
	translate <110, 0, 160>
}
object {objSketchWheelOuter
	pigment {color colLead}
	translate <50, 0, 210>
}
object {objSketchWheelOuter
	pigment {color colLead}
	translate <123, 0, 230>
}
object {objSketchWheelInner
	pigment {color colLead}
	translate <128, 0, 250>
}

//========== lay the drawing implements on the graph paper ==========
object {objPencil
	rotate <0, 125, 0>
	translate <150, 4, 138>
}

object {objEraser
	rotate <0, 115, 0>
	translate <52, 0, 292>
}

//========== scatter a few left-over construction blocks ==========
object {objBlock2x1
	texture {texShinyYellowPlastic}
	rotate <0, 0, 90>                   // flip on end
	rotate <0, -105, 0>
	translate <108.0, 0.0, 253.0>
}

object {objBlock4x1
		texture {texShinyRedPlastic}
		rotate <90, 0, 0>
		rotate <0, -20, 0>
		translate <114, 8.0, 280>
}

object {objBlock2x1
	texture {texShinyRedPlastic}
	rotate <90, 0, 0>
	rotate <0, -82, 0>
	translate <179, 8.0, 130>
}

//========== plonk the car onto the graph paper ==========
/*********************************************************************
The cars rear wheels have a radius of 15 and the axle is centred at y=2.7.
The front wheels have a radius of 12.5 and the axle is centred at y=5.9.
As (2.7-15)-(5.9-12.5)=-5.7 the font wheels are y=5.7 too high.
The rear axle centre is x=8 (negligible) and the font axle centre is x=136
so a quick and dirty rotation about the z axis will drop the bottom of the
front wheels down to the approximate level of the bottom of the back wheels.
Angle = arctan (-5.7 / 136.0) = -2.399962632 or -2.4 degrees.
*********************************************************************/
object {objCar
	rotate <0, 0, -2.4>
	rotate <0, -18, 0>
	translate <58, 12.3, 133>
}

/*********************************************************************
End of LEGOKA.POV
*********************************************************************/
