/*
 * Copyright 1993, 1994 by Ulrich Khn. All rights reserved.
 *
 * THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY, NOT
 * EVEN THE IMPLIED WARRANTIES OF MERCHANTIBILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE. USE AT YOUR OWN
 * RISK.
 */

/*
 * File : util.c
 *        utility functions for the nfs demon
 */

#ifndef UTIL_H
#define UTIL_H

#include <stat.h>
#include "../xfs/nfs.h"

/* get current time in a time stamp form, so we can validate some
 * things with it, for example the file handle.
 */
long get_timestamp();

int after(u_long u, u_long v);


/* convert between mint and nfs file mode representation */
int nfs_mode(int mode, int attrib);
int mint_mode(int mode, int type);

/* convert between mint and nfs representation of file attributes */
void fattr2stat(fattr *fa, struct stat *xa);
void stat2fattr(struct stat *xa, fattr *fa);

/* convert a path to the native MiNT format */
int path2abs(char *src, char *dest);


#endif
