/*
 * Copyright 1993, 1994 by Ulrich Khn. All rights reserved.
 *
 * THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY, NOT
 * EVEN THE IMPLIED WARRANTIES OF MERCHANTIBILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE. USE AT YOUR OWN
 * RISK.
 */

/*
 * File : nfssvc.h
 *        service functions for the nfs demon
 */

#ifndef NFSSVC_H
#define NFSSVC_H

#include <types.h>
#include "svc.h"
#include "../xfs/nfs.h"
#include "fh.h"



typedef union nfs_arguments
{
	svc_fh fhandle_arg;
	sattrargs sattr_arg;
	diropargs dirop_arg;
	readargs read_arg;
	writeargs write_arg;
	createargs create_arg;
	renameargs rename_arg;
	linkargs link_arg;
	symlinkargs symlink_arg;
	readdirargs readdir_arg;
} nfs_arguments;


typedef union nfs_results
{
	attrstat attrstat_res;
	diropres dirop_res;
	readlinkres readlink_res;
	readres read_res;
	nfsstat stat_res;
	readdirres readdir_res;
	statfsres statfs_res;
} nfs_results;



/* these service functions return an rpc result, the nfs result
 * (if rpc result is SUCCESS) is returned in the appropriate structure
 */

long nfsproc_null_svc(void *nix_in, void * nix_out);
long nfsproc_getattr_svc(svc_fh *fp, attrstat *rp);
long nfsproc_setattr_svc(sattrargs *ap, attrstat *rp);
long nfsproc_root_svc(void *nix_in, void *nix_out);
long nfsproc_lookup_svc(diropargs *ap, diropres *rp);
long nfsproc_readlink_svc(svc_fh *fp, readlinkres *rp);
long nfsproc_read_svc(readargs *ap, readres *rp);
long nfsproc_writecache_svc(void *nix_in, void *nix_out);
long nfsproc_write_svc(writeargs *ap, attrstat *rp);
long nfsproc_create_svc(createargs *ap, diropres *rp);
long nfsproc_remove_svc(diropargs *ap, nfsstat *rp);
long nfsproc_rename_svc(renameargs *ap, nfsstat *rp);
long nfsproc_link_svc(linkargs *ap, nfsstat *rp);
long nfsproc_symlink_svc(symlinkargs *ap, nfsstat *rp);
long nfsproc_mkdir_svc(createargs *ap, diropres *rp);
long nfsproc_rmdir_svc(diropargs *ap, nfsstat *rp);
long nfsproc_readdir_svc(readdirargs *ap, readdirres *rp);
long nfsproc_statfs_svc(svc_fh *ap, statfsres *rp);

void init_service();
void nfsprog_2(struct svc_req *req, SVCXPRT *xprt);
void handle_sighup(int sig);

#endif
