#ifndef _TIMER_H
#define _TIMER_H

#define EVTGRAN		10	/* timer granularity in ms */

struct event {
	long		delta;
	void		(*func) (long);
	long		arg;
	struct event	*next;
};

extern struct event	*event_add	(long, void (*) (long), long);
extern void		event_del	(struct event *);
extern long		event_delta	(struct event *);
extern struct event	*event_reset	(struct event *, long);

#endif /* _TIMER_H */
