#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#ifdef __MINT__
#include "../../include/sockios.h"
#endif

static int fd;

void
oob (int sig)
{
	static char buf[10];
	int r, atmark;

	r = recv (fd, buf, sizeof (buf) - 1, MSG_OOB);
	if (r < 0) {
		perror ("recv");
		return;
	}
	buf[r] = '\0';
	printf ("OOB : %s\n", buf);
	printf ("DATA: ");
	fflush (stdout);
	while (1) {
		r = ioctl (fd, SIOCATMARK, &atmark);
		if (r < 0) {
 			perror ("ioctl SIOCATMARK");
			break;
		}
		if (atmark) break;
		r = read (fd, buf, sizeof (buf) - 1);
		if (r < 0) {
			perror ("read");
			break;
		}
		buf[r] = '\0';
		printf ("%s", buf);
		fflush (stdout);
	}
	puts ("");
}

int
main (argc, argv)
	int argc;
	char *argv[];
{
	struct sockaddr_in sin;
	long r, pid;

	fd = socket (PF_INET, SOCK_STREAM, 0);
	if (fd < 0) {
		perror ("socket");
		return 1;
	}

	pid = getpid ();
	r = ioctl (fd, SIOCSPGRP, &pid);

#ifndef OOBINLINE
	signal (SIGURG, oob);
#else
	signal (SIGURG, SIG_IGN);
	pid = 1;
	setsockopt (fd, SOL_SOCKET, SO_OOBINLINE, &pid, sizeof (pid));
#endif
	sin.sin_family = AF_INET;
	sin.sin_port = htons (5678);
	sin.sin_addr.s_addr = argc < 2
		? htonl (INADDR_LOOPBACK)
		: inet_addr (argv[1]);

	r = connect (fd, (struct sockaddr *)&sin, sizeof (sin));
	if (r < 0) {
		perror ("connect");
		return 1;
	}
#ifndef OOBINLINE
	while (1) pause ();
#else
	{
		char buf[100];

		while (1) {
			r = read (fd, buf, sizeof (buf) - 1);
			if (r < 0) {
				perror ("read");
				return 1;
			}
			buf[r] = '\0';
			printf ("%s", buf);
			fflush (stdout);
		}
	}
#endif
	return 0;
}
