|
| Low level and interrupt routines for the PLIP channel 0 driver
|
| 03/13/94, Kay Roemer.
|

yamaha	  = 0xFFFF8800
mfp_gpip  = 0xFFFFFA01
mfp_aer   = mfp_gpip +  2
mfp_iera  = mfp_gpip +  6
mfp_ierb  = mfp_gpip +  8
mfp_ipra  = mfp_gpip + 10
mfp_iprb  = mfp_gpip + 12
mfp_isra  = mfp_gpip + 14
mfp_isrb  = mfp_gpip + 16
mfp_imra  = mfp_gpip + 18
mfp_imrb  = mfp_gpip + 20

|
| PSG register numbers
|

IOA       = 14
IOB       = 15
IOCTRL    = 7

|
| Exports
|
	.globl _pl0_set_strobe, _pl0_set_direction
	.globl _pl0_recv_byte, _pl0_send_byte
	.globl _pl0_got_ack, _pl0_send_ack
	.globl _pl0_cli, _pl0_sti
	.globl _pl0_old_busy_int, _pl0_busy_int

|
| Imports
|
	.globl _plip_int


	.text
|
| Set STROBE.
|

_pl0_set_strobe:
	movew	sr, d0
	oriw	#0x700, sr
	lea	yamaha:w, a0
	moveb	#IOA, a0@
	moveb	a0@, d1
	tstw	sp@(4)
	beq	L_100
	bset	#5, d1		| Set STROBE.
	bra	L_101
L_100:	bclr	#5, d1		| Clear STROBE.
L_101:	moveb	d1, a0@(2)
	movew	d0, sr
	rts
	
|
| Set the direction of the IO port B. Set to INPUT if argument is zero.
|

_pl0_set_direction:
	movew	sr, d1
	oriw	#0x700, sr
	lea	yamaha:w, a0
	moveb	#IOCTRL, a0@
	moveb	a0@, d0
	tstw	sp@(4)
	beq	L_110
	bset	#7, d0		| Set OUTPUT
	bra	L_111
L_110:	bclr	#7, d0		| Set INPUT
L_111:	moveb	d0, a0@(2)
	movew	d1, sr
	rts

|
| Read a byte from the parallel port. Return 0xff in the high byte
| if ack received.
|

_pl0_recv_byte:
	btst	#0, mfp_iprb:w		| data on port valid ?
	bne	L_160
	clrw	d0			| data is not valid
	rts

L_160:	moveb	#0xfe, mfp_iprb:w	| clear pending BUSY ints

	movew	sr, sp@-
	oriw	#0x700, sr
	lea	yamaha:w, a0
	moveb	#IOB, a0@

	movew	#0xff00, d0		| data is valid
	moveb	a0@, d0			| get data

	moveb	#IOA, a0@		| send ack
	moveb	a0@, d1
	bclr	#5, d1
	moveb	d1, a0@(2)
	nop
	nop
	bset	#5, d1
	moveb	d1, a0@(2)
	
	movew	sp@+, sr
	rts

|
| Write a byte to the parallel port and send ack.
|

_pl0_send_byte:
	movew	sr, d1
	oriw	#0x700, sr
	lea	yamaha:w, a0
	moveb	#IOB, a0@
	movew	sp@(4), d0
	moveb	d0, a0@(2)

	moveb	#IOA, a0@	| clear STROBE
	moveb	a0@, d0
	bclr	#5, d0
	moveb	d0, a0@(2)
	nop
	nop
	bset	#5, d0		| set STROBE
	moveb	d0, a0@(2)

	movew	d1, sr
	rts

|
| See if we got an acknoledge (BUSY dropped for some us)
|

_pl0_got_ack:
	btst	#0, mfp_iprb:w
	sne	d0
	bne	L_140
	rts
L_140:	moveb	#0xfe, mfp_iprb:w
	rts	

|
| Send an acknowledge (drop STROBE for some us)
|

_pl0_send_ack:
	movew	sr, d1
	oriw	#0x700, sr
	lea	yamaha:w, a0

	moveb	#IOA, a0@	| clear STROBE
	moveb	a0@, d0
	bclr	#5, d0
	moveb	d0, a0@(2)
	nop
	nop
	bset	#5, d0		| set STROBE
	moveb	d0, a0@(2)

	movew	d1, sr
	rts

|
| Disable BUSY interrupt.
|

_pl0_cli:
	bclr	#0, mfp_imrb:w
	rts

|
| Enable BUSY interrupt.
|

_pl0_sti:
	moveb	#0xfe, mfp_iprb:w	| clear pending ints
	bset	#0, mfp_imrb:w
	rts

|
| BUSY interrupt routine.
|

	.long	0x58425241	| "XBRA"
	.long	0x706c6970	| "plip"
_pl0_old_busy_int:
	.long	0xDEADFACE

_pl0_busy_int:
	moveml	d0-d1/a0-a1, sp@-
	movew	sr, d0
	oriw	#0x700, sr

	movew	sp@(16), d1	| sr before interrupt
	andw	#0x0700, d1	| keep IPL
	cmpiw	#0x0300, d1	| other interrupt in service ?
	bgt	L_120		| if so branch

	andw	#0xf8ff, d0	| clear IPL
	oriw	#0x0300, d0	| set IPL to 3
	movew	d0, sr		| allow other interrupts

	movew	#0, sp@-	| PLIP channel 0
	jsr	_plip_int	| handle interrupt
	addql	#2, sp

	oriw	#0x700, sr

L_120:	moveml	sp@+, d0-d1/a0-a1
	bclr	#0, mfp_isrb:w
	rte
