#ifndef _BUF_H
#define _BUF_H

#include "kerbind.h"

#define BUF_NORMAL		0
#define BUF_ATOMIC		1

#define BUF_BLOCK_SIZE		(1024*32L)
#define BUF_NSPLIT		7
#define BUF_MAGIC		0x73ec5a13ul

#define BUF_RESERVE_START	1
#define BUF_RESERVE_END		2

typedef struct buf {
	unsigned long	buflen;		/* buffer len, including header */
	char		*dstart;	/* start of data */
	char		*dend;		/* end of data */
	struct buf	*next;		/* next message */
	struct buf	*prev;		/* previous message */
	struct buf	*link3;		/* another next pointer */
	short		links;		/* usage counter */

	struct buf	*_n;		/* next buf in memory */
	struct buf	*_p;		/* previous buf memory */
	struct buf	*_nfree;	/* next free buf of same size */
	struct buf	*_pfree;	/* previous free buf of same size */
	char		data[0];
} BUF;

extern long	buf_init (void);
extern BUF	*buf_alloc (unsigned long, unsigned long, short);
extern void	buf_free (BUF *, short);
static void	buf_ref (BUF *);
static void	buf_deref (BUF *, short);
extern BUF	*buf_reserve (BUF *, long, short);

static inline void
buf_ref (buf)
	BUF *buf;
{
	++buf->links;
}

static inline void
buf_deref (buf, mode)
	BUF *buf;
	short mode;
{
	if (buf->links == 1) {
		buf_free (buf, mode);
	} else	--buf->links;
}

#endif /* _BUF_H */
