/*
 *	Definitions for the dummy or localhost IP implementation.
 *
 *	01/21/94, kay roemer.
 */

#ifndef _IP_H
#define _IP_H

#include "inet.h"
#include "buf.h"
#include "if.h"
#include "route.h"

/* Max number of packets to take from one interface before switching
 * to the next one. */
#define IP_PACKETS_PER_IF	5

/* Minimal accepable length of an IP packet */
#define IP_MINLEN		(sizeof (struct ip_dgram))

/* Some macros to access data in the ip header for higher level protocols */
#define IP_DADDR(buf)	(((struct ip_dgram *)(buf)->dstart)->daddr)
#define IP_SADDR(buf)	(((struct ip_dgram *)(buf)->dstart)->saddr)
#define IP_DATA(buf)	((buf)->dstart + \
	((struct ip_dgram *)(buf)->dstart)->hdrlen * sizeof (long))

/* IP datagramm */
struct ip_dgram {
	unsigned char	version:4;	/* version number */
#define IP_VERSION	4		/* current IP version */

	unsigned char	hdrlen:4;	/* header len */
	unsigned char	tos;		/* type of service and precedence */
	short		length;		/* datagram length */
	short		id;		/* datagram id */
	short		fragoff;	/* fragment offset */
#define IP_MF		0x2000		/* more fragments bit */
#define IP_DF		0x4000		/* don't fragment bit */
#define IP_FRAGOFF	0x1fff		/* fragment offset */

	unsigned char	ttl;		/* time to live */
	unsigned char	proto;		/* next protocol id */
	short		chksum;		/* checksum */
	unsigned long	saddr;		/* IP source address */
	unsigned long	daddr;		/* IP destination address */
	char		data[0];	/* options and data */
};

extern short		ip_is_brdcst_addr (unsigned long);
extern short		ip_is_local_addr (unsigned long);

extern unsigned long	ip_local_addr (unsigned long);
extern short		ip_same_addr (unsigned long, unsigned long);
extern unsigned long	ip_dst_addr (unsigned long);
extern short		ip_chk_addr (unsigned long, struct netif *);
#define IPADDR_NONE	0
#define IPADDR_LOCAL	1
#define IPADDR_BRDCST	2
#define IPADDR_BADCLASS	3

extern unsigned long	ip_netmask (unsigned long);
extern BUF *		ip_brdcst_copy (BUF *, struct netif *, struct route *,
			short);

extern void		ip_register (struct in_ip_ops *);
extern long		ip_send (unsigned long, unsigned long, BUF *, short,
				short);
#define IP_DONTROUTE	0x01
#define IP_BROADCAST	0x02

extern void		ip_input (void);
extern void		ip_forward (BUF *, struct netif *, short);

#endif /* _IP_H */
