/*
 *	Functions for copying data from/to io vectors to/from one
 *	continuous memory block.
 *
 *	PROBLEM: Should buf2iov_cpy change `iov_size' of the
 *	last element of iov[] to reflect the number of bytes
 *	actually copied into this buffer ??
 *
 *	01/01/94, kay roemer.
 */

#include "iov.h"

extern void *memcpy (void *, const void *, unsigned long n);

long
iov2buf_cpy (buf, nbytes, iov, niov)
	char *buf;
	long nbytes;
	struct iovec *iov;
	short niov;
{
	long todo = nbytes;

	if (niov <= 0) return 0;
	for (; niov; ++iov, --niov) {
		if (todo >= iov->iov_len) {
			memcpy (buf, iov->iov_base, iov->iov_len);
			todo -= iov->iov_len;
			buf += iov->iov_len;
		} else {
			memcpy (buf, iov->iov_base, todo);
			todo = 0;
			break;
		}
	}
	return (nbytes - todo);
}

long
buf2iov_cpy (buf, nbytes, iov, niov)
	char *buf;
	long nbytes;
	struct iovec *iov;
	short niov;
{
	long todo = nbytes;

	if (niov <= 0) return 0;
	for ( ; niov; ++iov, --niov) {
		if (todo >= iov->iov_len) {
			memcpy (iov->iov_base, buf, iov->iov_len);
			todo -= iov->iov_len;
			buf += iov->iov_len;
		} else {
			memcpy (iov->iov_base, buf, todo);
			todo = 0;
			break;
		}
	}
	return (nbytes - todo);
}
