#define	IDENTITY			(LONG)'zDCF'		/* Cookie-Kennung		*/
#define	DCF_VERS			0x0600				/* Protokoll:	06
															Programm:	xx		*/


typedef enum {DCF_OK, DCF_SYNC, DCF_RX, DCF_ERR}	DCF_MSG;
typedef enum {LOC=-1, UTC, MEZ, MESZ, UTC_3}	ZONE;
typedef enum {JOY_PORT, RI1_PORT, RI2_PORT}	DCF_PORT;
typedef struct	{	UWORD		version;
						DCF_MSG	valid;
						BOOLEAN	res_ant,
									a1,			/* Wechsel Winter-/Sommer-Zeit	*/
									a2;			/* Schaltsekunde						*/
						ZONE		zone;			/* dekodierte Zone					*/
						struct tm	_tm;		/* dekodierte Daten (valid?)		*/
						ZONE		zeitzone;	/* gewnschte Zeitzone				*/
						UWORD		intervall;	/* Zeit-Setz-Intervall (Minuten)	*/
						BOOLEAN	gem_set;		/* set-only: Zeit neu setzen		*/
						BOOLEAN	xbs_set;		/* set-only: Zeit neu setzen		*/
						ULONG		last_gem;	/* Zeit des letzten Zeit-Stellens*/
						ULONG		last_xbs;	/* Zeit des letzten Zeit-Stellens*/
						DCF_PORT	port;			/* Benutzter DCF-Port				*/
						BOOLEAN	quick_set;	/* Schnelles Setzen beim Start?	*/
						WORD		last_err;	/* Nummer des letzten Fehlers		*/
						ULONG		time_err;	/* _hz_200 des letzten Fehlers	*/
						BOOLEAN	boot_text;	/* Gespraechigkeit beim Booten	*/
					} DCF77;

/* Fehler-Nummern fr last_err:	*/
#define	E_GENERAL		0x1				/* Allgemeiner Fehler				*/
#define	E_FRAME			0x2				/* Fehler im Zeittelegramm			*/
#define	E_PARITY			0x3				/* Parity-Fehler im Telegramm		*/
#define	E_S_SHORT		0x4				/* Signal zu kurz						*/
#define	E_S_LONG			0x5				/* Signal zu lang						*/
#define	E_P_SHORT		0x6				/* Pause zu kurz						*/
#define	E_P_LONG			0x7				/* Pause zu lang						*/
#define	E_P_NOVAL		0x8				/* Pause hat falsche Lnge			*/
