/*
 *  VRT_CPYFM					(C) Digital Design 1991
 *
 *  COPY RASTER, TRANSPARENT
 *
 *  Diese Funktion kopiert ein einfarbiges Raster in ein farbiges Raster.
 *  Die Farbe der gesetzten und nicht gesetzten Punkte wird definiert.
 *  Im Gegensatz zur COPY-RASTER-OPAQUE-Funktion VRO_CPYFMVRO_CPYF.C sind hier nur
 *  die auch bei der SET-WRITE-MODUS-Funktion VSWR_MODE..\ATTRIB\VSWR_MOD.C mglichen logi-
 *  schen Verknpfungen erlaubt (replace, transparent, XOR, reverse
 *  transparent).
 *  Wenn die Gre der beiden Raster unterschiedlich ist, bertrgt die
 *  Funktion in der Gre des Quellrasters, angefangen bei der oberen
 *  linken Ecke des Zielrasters.
 */
#include <gemdefs.h>

void vrt_cpyfm( int handle, int vr_mode, int *pxyarray,
		MFDB *psrcMFDB, MFDB *pdesMFDB, int *color_index )
{
  *(MFDB far **)(contrl + 7) = psrcMFDB; /* Doppelwort-Adresse MFDB	*/
					 /* des Quellrasters		*/
  *(MFDB far **)(contrl + 9) = pdesMFDB; /* Doppelwort-Adresse MFDB	*/
					 /* des Zielrasters		*/
  intin[0] = vr_mode; /* Zeichenmodus (siehe Funktion vswr_mode)	*/
  intin[1] = color_index[0]; /* Farbindex der gesetzten Punkte		*/
  intin[2] = color_index[1]; /* Farbindex der nicht gesetzten Punkte	*/
  vdipb[2] = pxyarray; /* pxyarray[0] = x-Koordinate des Eckpunktes	*
			*		des Quellrasters		*
			* pxyarray[1] = y-Koordinate des Eckpunktes	*
			*		des Quellrasters		*
			* pxyarray[2] = x-Koordinate des diagonal	*
			*		gegenberliegenden Eckpunktes	*
			*		des Quellrasters		*
			* pxyarray[3] = y-Koordinate des diagonal	*
			*		gegenberliegenden Eckpunktes	*
			*		des Quellrasters		*
			* pxyarray[4] = x-Koordinate des Eckpunktes	*
			*		des Zielrasters 		*
			* pxyarray[5] = y-Koordinate des Eckpunktes	*
			*		des Zielrasters 		*
			* pxyarray[6] = x-Koordinate des diagonal	*
			*		gegenberliegenden Eckpunktes	*
			*		des Zielrasters 		*
			* pxyarray[7] = y-Koordinate des diagonal	*
			*		gegenberliegenden Eckpunktes	*
			*		des Zielrasters 		*/
  VDI( 121, 4, 3, handle );

  vdipb[2] = ptsin;
}
