/*
 *  V_ARC                                       (C) Digital Design 1990
 *
 *  Die Funktion zeichnet einen Kreisausschnitt, wobei Anfangs- und End-
 *  winkel definiert werden.
 *  Folgende Attribute fr Linien finden dabei Verwendung:
 *      Linienfarbe
 *      Linientyp
 *      Zeichenmodus
 *      Linienbreite
 *      Endform
 */
#include <gemdefs.h>

void v_arc( int handle, int x, int y, int radius, int begang, int endang )
{
  intin[0] = begang; /* Startwinkel (0-3600)                            */
  intin[1] = endang; /* Endwinkel (0-3600)                              */
  ptsin[0] = x; /* X-Koordinate des Mittelpunktes                       */
  ptsin[1] = y; /* Y-Koordinate des Mittelpunktes                       */
  ptsin[2] = ptsin[3] = ptsin[4] = ptsin[5] = ptsin[7] = 0;
  ptsin[6] = radius; /* Radius                                          */

  contrl[5] = 2; VDI( 11, 4, 2, handle );
}

