/*
 *  VQT_EXTENT					(C) Digital Design 1990
 *
 *  INQUIRE TEXT EXTENT
 *
 *  Diese Funktion berechnet auf Grundlage der aktuellen Text-Attribute
 *  die Ausmae eines spezifizierten Strings. Es werden die vier Eck-
 *  punkte des Rechteckes, das den String umfat, relativ ausgegeben.
 *  Das stringumfassende Rechteck wird mit den beiden Ecken links vom
 *  Text an die X- und Y-Achse gelegt. Die Eckpunkte des Rechteckes
 *  werden unten links beginnend gegen den Uhrzeigersinn numeriert.
 */
#include <gemdefs.h>

void vqt_extent( int handle, char *string, int *extent )
{
  int  *pintin;
  char *pstring;

  pintin = intin; pstring = string;
  while ((*pintin++ = (unsigned char)*pstring++) != 0);
  vdipb[4] = extent;

  VDI( 116, 0, (int)(pstring - string - 1), handle );

  vdipb[4] = ptsout; /* extent[0] = relative x-Koordinate fr Punkt 1	*
		      * 	    des Textes				*
		      * extent[1] = relative y-Koordinate fr Punkt 1	*
		      * 	    des Textes				*
		      * extent[2] = relative x-Koordinate fr Punkt 2	*
		      * 	    des Textes				*
		      * extent[3] = relative y-Koordinate fr Punkt 2	*
		      * 	    des Textes				*
		      * extent[4] = relative x-Koordinate fr Punkt 3	*
		      * 	    des Textes				*
		      * extent[5] = relative y-Koordinate fr Punkt 3	*
		      * 	    des Textes				*
		      * extent[6] = relative x-Koordinate fr Punkt 4	*
		      * 	    des Textes				*
		      * extent[7] = relative y-Koordinate fr Punkt 4	*
		      * 	    des Textes				*/
}
