/*
 *  VSIN_MODE                                   (C) Digital Design 1990
 *
 *  SET INPUT MODE
 *
 *  Diese Funktion bestimmt den Modus der logischen Eingabeeinheiten.
 *  VDI untersttzt vier spezifizierte Eingabeeinheiten:
 *  - POSITIONSEINGABEN werden in der Standardkonfiguration mit der
 *    Maus oder den Cursor-Tasten zur Steuerung des Grafikcursors
 *    gemacht.
 *  - WERTVERNDERNDE EINGABEN werden mit den Cursortasten "oben" und
 *    "unten" vorgenommen. Diese Tasten bewirken lediglich den Wert, den
 *    die Funktion zurckgibt.
 *  - Die logische AUSWAHLEINHEIT sind die Funktionstasten. Es wird eine
 *    Auswahlnummer ermittelt, die der bettigten Funktionstaste ent-
 *    spricht.
 *  - STRINGEINGABE erfolgt ber die Tastatur.
 *  Diese Funktion legt den Modus fest, in dem die Funktionen der logi-
 *  schen Eingabeeinheiten arbeiten sollen (request oder sample).
 */
#include <gemdefs.h>

int vsin_mode( int handle, int dev_type, int mode )
{
  intin[0] = dev_type; /* logisches Eingabegert:                       *
                        *       1 = Positions-Eingabegert              *
                        *       2 = Wert-Eingabegert                   *
                        *       3 = Auswahl-Eingabegert                *
                        *       4 = String-Eingabegert                 */
  intin[1] = mode; /* Eingabemodus:  1 = request-Modus                  *
                    *                2 = sample-Modus                   */
  VDI( 33, 0, 2, handle );

  return intout[0]; /* = set_mode: Ausgewhlter Eingabemodus            */
}

