/*
 *  VSC_FORM                                    (C) Digital Design 1990
 *
 *  SET MOUSE FORM
 *
 *  Diese Funktion definiert eine neue Form des Grafikcursors. Das Raster
 *  des Cursors ist 16 * 16 Punkte und wird in zwei Arrays von 16 Worten
 *  definiert. Das Bit 15 des ersten Wortes ist der obere linke Punkt der
 *  Cursordefinition. Das erste Array, die Cursormaske, kennzeichnet die
 *  Cursorform ohne Farbinformation. Im zweiten Array werden die Punkte
 *  auf 1 gesetzt, die in der Vordergrundfarbe erscheinen sollen.
 *  Weiterhin wird ein Aktionspunkt innerhalb der Cursorform angegeben.
 *  Dieser Punkt bestimmt die exakte Position des Cursors. Die Spitze des
 *  Standard-Cursorpfeils z.B. ist der Aktionspunkt dieses Cursors. Der
 *  Aktionspunkt wird relativ zur oberen linken Ecke des Cursorrasters
 *  adressiert.
 */
#include <gemdefs.h>

void vsc_form( int handle, int *pcur_form )
{
  vdipb[1] = pcur_form; /* Inhalt des Elementes Nummer                  *
                         * 0: x-Koordinate des Aktionspunktes           *
                         * 1: y-Koordinate des Aktionspunktes           *
                         * 2: reserviert fr knftige Anwendung         *
                         *    (mu auf 1 gesetzt werden)                *
                         * 3: Farbindex Maske (normal 0)                *
                         * 4: Farbindex Cursorform (normal 1)           *
                         * 5-20: 16-Wort-Gruppe der Maske               *
                         * 21-36: 16-Wort-Gruppe der Cursorform         */
  VDI( 111, 0, 37, handle );

  vdipb[1] = intin;
}

