/*
 *  VRQ_VALUATOR                                (C) Digital Design 1990
 *
 *  INPUT VALUATOR, REQUEST MODE
 *
 *  Diese Funktion verwaltet die logische Eingabeeinheit zur Wertvern-
 *  derung. Die CURSOR-OBEN- und CURSOR-UNTEN-Taste z.B. sind die Stan-
 *  dardtasten zur wertverndernden Eingabe. Es wird stets ein Wert zwi-
 *  schen 1 und 100 zurckgegeben, je nach bettigter Taste oder Tasten-
 *  kombination. Fr die Cursor-Tasten gilt die folgende Vereinbarung:
 *      CURSOR-OBEN             Wert+10
 *      CURSOR-UNTEN            Wert-10
 *      SHIFT/CURSOR-OBEN       Wert+1
 *      SHIFT/CURSOR-UNTEN      Wert-1
 */
#include <gemdefs.h>

void vrq_valuator( int handle, int valuator_in,
                   int *valuator_out, int *terminator )
{
  intin[0] = valuator_in; /* initialisierender Wert                     */

  VDI( 29, 0, 1, handle );

  *valuator_out = intout[0]; /* ermittelter Wert                        */
  *terminator = intout[1]; /* bettigte Taste                           */
}
/* siehe auch: vsm_valuatorVSM_VALU.C, vsin_modeVSIN_MOD.C */

