/*
 *  V_OPNWK					(C) Digital Design 1991
 *
 *  OPEN WORKSTATION
 *
 *  Diese Funktion ldt den Gertetreiber fr ein bestimmtes Ein/Ausgabe-
 *  gert. Das Ein/Ausgabegert wird mit den Parametern im Eingabe-
 *  Array initialisiert. Das Ausgabe-Array bermittelt nhere Informa-
 *  tionen zu dem Gert. Weiterhin bergibt diese Funktion dem Programm
 *  eine Gertekennung.
 *  Falls das Gert aus welchen Grnden auch immer nicht geffnet werden
 *  kann, ist die Gertekennung Null.
 */
#include <gemdefs.h>

void v_opnwk( int work_in[103], int *handle, int work_out[57] )
{
  vdipb[1] = work_in; /* Inhalt des Feldelementes Nummer		*
		       * 0: Gerte-Identifikation, gibt den zu ladenden *
		       *    Gertetreiber an				*
		       * 1: Linientyp					*
		       * 2: Linienfarbe 				*
		       * 3: Markierungstyp				*
		       * 4: Markierungsfarbe				*
		       * 5: Zeichensatz 				*
		       * 6: Schriftfarbe				*
		       * 7: Flltyp					*
		       * 8: Fllmuster					*
		       * 9: Fllfarbe					*
		       * 10: Koordinatenflag:				*
		       *	0 = Normalkoordinaten			*
		       *	1 = reserviert				*
		       *	2 = Rasterkoordinaten			*/
  vdipb[3] = work_out;
  vdipb[4] = work_out + 45;

  VDI( 1, 0, 103, *handle );

  vdipb[1] = intin;
  vdipb[3] = intout;
  vdipb[4] = ptsout;
  *handle = contrl[6];

  /* Inhalt von work_out-Nummer 					*
   * 0: Rasterbreite des Gertes in Punkte oder Schritte		*
   * 1: Rasterhhe des Gertes in Punkte oder Schritte			*
   * 2: 0								*
   * 3: Breite eines Punktes oder Plotterschrittes in mm/1000		*
   * 4: Hhe eines Punktes oder Plotterschrittes in mm/1000		*
   * 5: Anzahl der verschiedenen Schriftgren (0 = unbegrenzt) 	*
   * 6: Anzahl der Linientypen						*
   * 7: Anzahl der Linienbreiten (0 = unbegrenzt)			*
   * 8: Anzahl der Markierungsarten					*
   * 9: Anzahl der Markierungsgren (0 = unbegrenzt)			*
   * 10: Anzahl der Zeichenstze des Gertes				*
   * 11: Anzahl der Muster						*
   * 12: Anzahl der Schraffier-Arten					*
   * 13: Anzahl der Farben (2 bei Monochrom-Monitor)			*
   * 14: Anzahl der Grafik-Grundfunktionen				*
   * 15-24: Sequentielle Liste der untersttzten Grafik-Grundfunktionen.*
   *	    Eine -1 kennzeichnet das Ende der Liste:			*
   *		1 = Balken						*
   *		2 = Bogen						*
   *		3 = Kreissegment					*
   *		4 = Kreis						*
   *		5 = Ellipse						*
   *		6 = elliptischer Bogen					*
   *		7 = Ellipsensegment					*
   *		8 = abgerundetes Rechteck				*
   *		9 = geflltes abgerundetes Rechteck			*
   *		10 = justierter Grafiktext				*
   * 25-34: sequentielle Liste der Attribute der Grundfunktionen:	*
   *		0 = Linienoperation					*
   *		1 = Markierungsoperation				*
   *		2 = Text						*
   *		3 = ausgefllter Bereich				*
   *		4 = kein Attribut					*
   * 35: Flag Farbdarstellung:	0 = nicht verfgbar			*
   *				1 = verfgbar				*
   * 36: Flag fr Textrotation:  0 = nicht verfgbar			*
   *				 1 = verfgbar				*
   * 37: Flag ausgefllte Bereiche:  0 = nicht verfgbar		*
   *				     1 = verfgbar			*
   * 38: Flag Funktion v_cellarray: 0 = nicht verfgbar 		*
   *				    1 = verfgbar			*
   * 39: Anzahl der verfgbaren Farben:  0 = mehr als 32767 Farben	*
   *					 1 = monochrom			*
   *					>2 = Anzahl der Farben		*
   * 40: Grafikcursor-Kontrolle:					*
   *		 1 = nur ber Tastatur					*
   *		 2 = ber Tastatur und ein anderes Gert (Mouse)	*
   * 41: wertverndernde Eingaben:  1 = ber Tastatur			*
   *				    2 = anderes Gert			*
   * 42: Auswahltasten:  1 = Funktionstasten				*
   *			 2 = anderes Tastenfeld 			*
   * 43: alphanumerische Eingabe:  1 = Tastatur 			*
   * 44: Art des Arbeitsgertes:  0 = Ausgabegert			*
   *				  1 = Eingabegert			*
   *				  2 = Ein/Ausgabegert			*
   *				  3 = reserviert			*
   *				  4 = Metafile-Ausgabe			*
   * 45: minimale Zeichenbreite 					*
   * 46: minimale Zeichenhhe						*
   * 47: maximale Zeichenbreite 					*
   * 48: maximale Zeichenhhe						*
   * 49: minimale Zeilenbreite						*
   * 50: 0								*
   * 51: maximale Zeilenbreite						*
   * 52: 0								*
   * 53: minimale Markierungsbreite					*
   * 54: minimale Markierungshhe					*
   * 55: maximale Markierungsbreite					*
   * 56: maximale Markierungshhe					*/
}
/* siehe auch: V_CLSWKV_CLSWK.C */
