/*
 *  WIND_SET					(C) Digital Design 1990
 *
 *  ndert das Aussehen des Randbereichs oder der Titelzeile
 *  eines Fensters.
 */
#include <gemdefs.h>
#include <stdarg.h>

typedef char *STRINGP;

int wind_set( int wi_shandle, int wi_sfield, ...
	      /* int wi_sw1, int wi_sw2, int wi_sw3, int wi_sw4 */ )
{
  va_list ap;

  intin[0] = wi_shandle; /* Window Handle des zu ndernden Fensters	*/
  intin[1] = wi_sfield; /* gibt die Art der nderung an:		*
			 *						*
			 * 1: In wi_sw1 wird das Bit-Feld gespeichert,	*
			 * das festlegt, welche Komponenten des Randbe- *
			 * reichs des Fensters sichtbar sein sollen.	*
			 * Die Bedeutung der Bits im Bit-Feld ist die	*
			 * gleiche wie bei WIND_CREATEWIND_CRE.C.                 *
			 *						*
			 * 2: wi_sw1 und wi_sw2 stellen einen Zeiger	*
			 * dar, der auf einen String im Speicher zeigt. *
			 * Dieser String ist der Titel des Fensters.	*
			 * Er mu folgendermaen im Speicher		*
			 * organisiert sein:				*
			 *	1.Byte = 1.Zeichen			*
			 *	2.Byte = 2.Zeichen			*
			 *	  ...					*
			 *	n.Byte = letztes Zeichen		*
			 *    n+1.Byte = Null				*
			 *    n+2.Byte = Null				*
			 * Der Text wird automatisch zentriert. 	*
			 *						*
			 * 3: wi_sw1 und wi_sw2 sind ein Zeiger auf	*
			 * einen String, der die Informationszeile des	*
			 * Fensters darstellt. Es gilt sinngem das	*
			 * gleiche wie bei 2.				*
			 *						*
			 * 5: Das laufende Fenster wird festgelegt.	*
			 * Diese Option korrespondiert mit dem Befehl	*
			 * WIND_GETWIND_GET.C, Option 5 und 6.                    *
			 *						*
			 * 8: Die relative Position des horizontalen	*
			 * Schiebers wird verndert. Die Parameter sind *
			 * die gleichen wie diejenigen von WIND_GETWIND_GET.C,    *
			 * Option 8.					*
			 *						*
			 * 9: Die relative Position des vertikalen	*
			 * Schiebers wird verndert. Die Parameter sind *
			 * die gleichen wie diejenigen von WIND_GETWIND_GET.C,    *
			 * Option 9.					*
			 *						*
			 * 10: Das momentan aktive Fenster wird festge- *
			 * legt. Es kann nur ein Fenster gleichzeitig	*
			 * aktiv, d.h. vom Benutzer vernderbar sein.	*
			 * Diese Option korrespondiert mit dem Befehl	*
			 * WIND_GETWIND_GET.C, Option 10.                         *
			 *						*
			 * 14: Die Adresse einer neuen GEM DESKTOP-	*
			 * Zeichnung fr den Grundzustand wird		*
			 * bergeben:					*
			 *	wi_sw1					*
			 *  und wi_sw2 = Adresse der Objektbaumstruktur *
			 *	wi_sw3 = Index des zuerst zu zeich-	*
			 *		 nenden Objekts 		*
			 *						*
			 * 15: Die relative Gre des horizontalen	*
			 * Schiebers wird verndert. Die Parameter sind *
			 * die gleichen wie diejenigen von WIND_GETWIND_GET.C,    *
			 * Option 15.					*
			 *						*
			 * 16: Die relative Gre des vertikalen	*
			 * Schiebers wird verndert. Die Parameter sind *
			 * die gleichen wie diejenigen von WIND_GETWIND_GET.C,    *
			 * Option 16.					*/
  va_start( ap, wi_sfield );
  switch (wi_sfield)
  {
    case 1: case 8: case 9: case 10: case 15: case 16:
      intin[2] = va_arg( ap, int ); break;
    case 2: case 3:
      *(char far **)(intin + 2) = va_arg( ap, STRINGP ); break;
    case 5:
      intin[2] = va_arg( ap, int );
      intin[3] = va_arg( ap, int );
      intin[4] = va_arg( ap, int );
      intin[5] = va_arg( ap, int ); break;
    case 14:
      *(char far **)(intin + 2) = va_arg( ap, STRINGP );
      intin[4] = va_arg( ap, int );
  }
  va_end( ap );

  AES( 105, 6, 1, 0, 0 );

  return intout[0]; /* = wi_sreturn: positiv bei Erfolg, 0 bei Fehler	*/
}
