/*
 *  WIND_CREATE                                 (C) Digital Design 1990
 *
 *  Ein Fenster wird erzeugt, aber noch nicht dargestellt.
 *  Die Darstellung erfolgt erst mit der Funktion WIND_OPENWIND_OPE.C.
 */
#include <gemdefs.h>

int wind_create( int wi_crkind, int wi_crwx, int wi_crwy,
                 int wi_crww, int wi_crwh )
{
  intin[0] = wi_crkind; /* legt fest, welche Komponenten des Rand-      *
                         * bereichs des Fensters sichtbar und aktiv     *
                         * sein sollen. Es handelt sich hierbei um ein  *
                         * Bit-Feld, ein gesetztes Bit steht fr eine   *
                         * aktive Komponente, ein gelschtes fr eine   *
                         * inaktive. Die Bits haben folgende Bedeutung: *
                         *  0 = NAME (Titelzeile mit Namen des Fensters)*
                         *  1 = CLOSE (Lschfeld)                       *
                         *  2 = FULL (Bildschirmformatfeld)             *
                         *  3 = MOVE (Bewegungsfeld)                    *
                         *  4 = INFO (Informationszeile)                *
                         *  5 = SIZE (Formatfeld)                       *
                         *  6 = UPARROW (Pfeil nach oben)               *
                         *  7 = DNARROW (Pfeil nach unten)              *
                         *  8 = VSLIDE (vertikaler Schieber)            *
                         *  9 = LFARROW (Pfeil nach links)              *
                         * 10 = RTARROW (Pfeil nach rechts)             *
                         * 11 = HSLIDE (horizontaler Schieber)          */
  intin[1] = wi_crwx; /* X-Koordinate des grtmglichen Fensteraus-    *
                       * maes                                          */
  intin[2] = wi_crwy, /* Y-Koordinate des grtmglichen Fensteraus-    *
                       * maes                                          */
  intin[3] = wi_crww; /* Breite des grtmglichen Fensterausmaes      */
  intin[4] = wi_crwh; /* Hhe des grtmglichen Fensterausmaes        */

  AES( 100, 5, 1, 0, 0 );

  return intout[0]; /* = wi_crreturn: Window Handle (Fensterkennziffer) *
                     * des Fensters. Eine negative Zahl zeigt an, da   *
                     * AES keine Fenster mehr zur Verfgung hat, weil   *
                     * die Kapazitt erschpft ist.                     */
}
/* siehe auch: wind_deleteWIND_DEL.C */

