/*
 *  WIND_CALC                                   (C) Digital Design 1990
 *
 *  Bei bekannten Ausmaen des Arbeitsbereichs eines Fensters werden die
 *  Umriausmae des Fensters berechnet. Falls die Umriausmae des
 *  Fensters bekannt sind, werden die Ausmae des Arbeitsbereichs
 *  berechnet.
 */
#include <gemdefs.h>

int wind_calc( int wi_ctype, int wi_ckind, int wi_cinx, int wi_ciny,
               int wi_cinw, int wi_cinh, int *coutx, int *couty,
               int *coutw, int *couth )
{
  intin[0] = wi_ctype; /* entscheidet, welche der beiden mglichen      *
                        * Funktionen ausgefhrt werden soll:            *
                        *   0 = Ausgabe der Gesamtausmae               *
                        *   1 = Ausgabe der Ausmae des Arbeitsbereichs */
  intin[1] = wi_ckind; /* ein Bit-Feld, das die sichtbaren Komponenten  *
                        * des Randbereichs des Fensters angibt. Diese   *
                        * werden zur Berechnung der Fenstergre heran- *
                        * gezogen. Die Bedeutung der Bits ist die       *
                        * gleiche wie beim Befehl WIND_CREATEWIND_CRE.C.          */
  intin[2] = wi_cinx; /* X-Koordinate des Eingabebereichs               */
  intin[3] = wi_ciny; /* Y-Koordinate des Eingabebereichs               */
  intin[4] = wi_cinw; /* Breite des Eingabebereichs                     */
  intin[5] = wi_cinh; /* Hhe des Eingabebereichs                       */

  AES( 108, 6, 5, 0, 0 );

  *coutx = intout[1]; /* X-Koordinate des Ausgabebereichs               */
  *couty = intout[2]; /* Y-Koordinate des Ausgabebereichs               */
  *coutw = intout[3]; /* Breite des Ausgabebereichs                     */
  *couth = intout[4]; /* Hhe des Ausgabebereichs                       */
  return intout[0]; /* = wi_creturn: positiv bei Erfolg, 0 bei Fehler   */
}

