/*
 *  OBJC_DRAW                                   (C) Digital Design 1990
 *
 *  Zeichnen eines Objektbaumes, wobei ein Rechteck gewhlt werden kann,
 *  das die Zeichengrenzen festlegt.
 *  Weiterhin kann festgelegt werden, bis zu welcher Ebene der Baum
 *  gezeichnet werden soll.
 */
#include <gemdefs.h>

int objc_draw( OBJECT *ob_drtree, int ob_drstartob,
               int ob_drdepth, int ob_drxclip, int ob_dryclip,
               int ob_drwclip, int ob_drhclip )
{
  intin[0] = ob_drstartob; /* der Index des Objektes, das als erstes    *
                            * gezeichnet werden soll.                   */
  intin[1] = ob_drdepth; /* Die Anzahl der Ebenen, die gezeichnet       *
                          * werden sollen. Objekte mit einer hheren    *
                          * Ebenennummer als die angegebene werden beim *
                          * Zeichnen ignoriert. Es gilt folgende        *
                          * Ebenenvereinbarung:                         *
                          *    0 = Wurzelobjekt                         *
                          *    1 = Wurzelobjekt und untergeordnete      *
                          *        Objekte                              *
                          *    2 = Wurzelobjekt, untergeordnete Objekte *
                          *        und diesen Objekten untergeordnete   *
                          *        Objekte                              *
                          *  3-n = usw.                                 */
  intin[2] = ob_drxclip; /* X-Koordinate des Begrenzungsrechtecks       */
  intin[3] = ob_dryclip; /* Y-Koordinate des Begrenzungsrechtecks       */
  intin[4] = ob_drwclip; /* Breite des Begrenzungsrechtecks             */
  intin[5] = ob_drhclip; /* Hhe des Begrenzungsrechtecks               */
  addrin[0] = ob_drtree; /* Adresse des Objektbaumes                    */

  AES( 42, 6, 1, 1, 0 );

  return intout[0]; /* = ob_drreturn: positiv bei Erfolg, 0 bei Fehler  */
}

