/*
 *  GRAF_WATCHBOX                               (C) Digital Design 1990
 *
 *  Der Mauszeiger wird daraufhin berwacht, ob er ein rechteckiges Feld
 *  betritt oder verlt. Dieses Feld ndert dann in Abhngigkeit von der
 *  Mausposition seinen Zustand. Die Funktion ist beendet, sobald der
 *  Benutzer den Mausknopf loslt. Das Rechteck mu Teil eines Objekt-
 *  baums sein.
 */
#include <gemdefs.h>

int graf_watchbox( OBJECT *gr_wptree, int gr_wobject,
                   int gr_winstate, int gr_woutstate )
{
  /* intin[0] = reserviert; */
  intin[1] = gr_wobject; /* der Index des Objektes                      */
  intin[2] = gr_winstate; /* der Status des Objektes beim Betreten mit  *
                           * dem Mauszeiger (bei gedrcktem Knopf):     *
                           *    0 = NORMAL                              *
                           *    1 = SELECTED                            *
                           *    2 = CROSSED                             *
                           *    4 = CHECKED                             *
                           *    8 = DISABLED                            *
                           *   16 = OUTLINED                            *
                           *   32 = SHADOWED                            */
  intin[3] = gr_woutstate; /* der Status des Objektes beim Verlassen    *
                            * mit dem Mauszeiger (bei gedrcktem Knopf),*
                            * siehe gr_winstate                         */
  addrin[0] = gr_wptree; /* die Adresse des Objektbaumes                */

  AES( 75, 4, 1, 1, 0 );

  return intout[0]; /* = gr_wreturn: Position des Mauszeigers beim      *
                     * Loslassen des Knopfes:                           *
                     *          0 = auerhalb des Rechtecks             *
                     *          1 = innerhalb des Rechtecks             */
}

