/*
 *  GRAF_DRAGBOX                                (C) Digital Design 1990
 *
 *  Der Benutzer kann mit dem Mauszeiger ein Rechteck innerhalb eines
 *  anderen Rechtecks verschieben.
 */
#include <gemdefs.h>

int graf_dragbox( int gr_dwidth, int gr_dheight, int gr_dstartx,
                  int gr_dstarty, int gr_dboundx, int gr_dboundy,
                  int gr_dboundw, int gr_dboundh,
                  int *gr_dfinishx, int *gr_dfinishy )
{
  intin[0] = gr_dwidth;  /* die Breite des verschiebbaren Rechtecks     */
  intin[1] = gr_dheight; /* die Hhe des verschiebbaren Rechtecks       */
  intin[2] = gr_dstartx; /* die Anfangs-X-Koordinate des verschiebbaren *
                          * Rechtecks                                   */
  intin[3] = gr_dstarty; /* die Anfangs-Y-Koordinate des verschiebbaren *
                          * Rechtecks                                   */
  intin[4] = gr_dboundx; /* die X-Koordinate des Begrenzungsrechtecks   */
  intin[5] = gr_dboundy; /* die Y-Koordinate des Begrenzungsrechtecks   */
  intin[6] = gr_dboundw; /* die Breite des Begrenzungsrechtecks         */
  intin[7] = gr_dboundh; /* die Hhe des Begrenzungsrechtecks           */

  AES( 71, 8, 3, 0, 0 );
  *gr_dfinishx = intout[1]; /* die X-Koordinate des verschiebbaren      *
                             * Rechtecks zum Zeitpunkt des Loslassens   */
  *gr_dfinishy = intout[2]; /* die Y-Koordinate des verschiebbaren      *
                             * Rechtecks zum Zeitpunkt des Loslassens   */
  return intout[0]; /* = gr_dreturn: positiv bei Erfolg, 0 bei Fehler.  */
}
/* siehe auch: graf_moveboxGRAF_MOV.C, graf_rubberboxGRAF_RUB.C, graf_slideboxGRAF_SLI.C */

