/*
 *  FORM_ALERT					(C) Digital Design 1990
 *
 *  Darstellen einer Warnmeldung.
 *  Es handelt sich hierbei um eine besondere Form von Formularen.
 *  Neben einem Piktogramm (optional) wird ein zu programmierender
 *  Begleittext ausgegeben. Der Benutzer kann die Meldung quittieren,
 *  indem er eins von hchstens 3 Quittierungsfeldern anklickt bzw.
 *  Return bettigt (optional). Die Gre des Feldes fr die Warn-
 *  meldung sowie die Position (Zentrum des Bildschirms) wird von AES..\AES.HLP
 *  bestimmt und kann nicht verndert werden. Die Informationen ber die
 *  3 Komponenten werden in einem String gespeichert, wobei um jede Kom-
 *  ponente ein Paar eckige Klammern gesetzt werden mu.
 *  Beim Aufruf dieser Funktion werden folgende Schritte automatisch von
 *  AES..\AES.HLP durchgefhrt:
 *
 *  1. Anhand des oben beschriebenen Strings wird ein passender Objekt-
 *     baum definiert.
 *
 *  2. Der Bildschirmspeicher wird teilweise in einen Puffer gerettet.
 *
 *  3. OBJC_DRAW..\OBJC\OBJC_DRA.C wird aufgerufen, um die Warnmeldung darzustellen.
 *
 *  4. FORM_DOFORM_DO.C wird aufgerufen, um auf die Benutzereingabe zu warten.
 *
 *  5. Wenn der Benutzer die Warnmeldung quittiert hat, wird der zer-
 *     strte Bildschirmbereich restauriert.
 *
 *  6. Der Applikation wird mitgeteilt, welcher Knopf angeklickt worden
 *     ist.
 */
#include <gemdefs.h>

int form_alert( int fo_adefbttn, const char *fo_astring )
{
  intin[0] = fo_adefbttn; /* Nummer des Knopfes, dessen Auslsen durch	*
			   * Bettigen von Return simuliert werden kann:*
			   *	0 = kein Knopf				*
			   *	1 = erster Knopf			*
			   *	2 = zweiter Knopf			*
			   *	3 = dritter Knopf			*/
  addrin[0] = fo_astring; /* Adresse des Strings, der das Aussehen der	*
			   * Warnmeldung bestimmt.			*
			   * Aufbau des Strings:			*
			   *	[Piktogrammnummer][Text][Text der	*
			   *	Quittierungsknpfe]			*
			   * Folgende Syntax ist der Darstellung der	*
			   * Komponenten zugeordnet:			*
			   *						*
			   * 1. Piktogramm:				*
			   * Eine Ziffer gibt an, ob ein bzw. welches	*
			   * Piktogramm links vom Text dargestellt	*
			   * werden soll. Drei Piktogramme stehen zur	*
			   * Auswahl:					*
			   *	0 = kein Piktogramm			*
			   *	1 = NOTE-Piktogramm			*
			   *	2 = WAIT-Piktogramm			*
			   *	3 = STOP-Piktogramm			*
			   *						*
			   * 2. Text:					*
			   * Der Text darf aus maximal 5 Zeilen mit	*
			   * maximal 40 Zeichen pro Zeile bestehen. Das *
			   * Zeichen "|" (logisches Oder) trennt Zeilen *
			   * voneinander.				*
			   *						*
			   * 3. Text der Quittierungsknpfe:		*
			   * Die Zahl der Quittierungsknpfe mu zwi-	*
			   * schen 1 und 3 liegen. Der Text auf jedem	*
			   * Knopf darf maximal 20 Zeichen lang sein.	*
			   * Beim Funktionsaufruf kann ein Knopf als	*
			   * Ausgangsknopf definiert werden, d.h. da	*
			   * das Anklicken dieses Knopfes durch das Be- *
			   * ttigen der Return-Taste simuliert werden	*
			   * kann. Dieser Knopf wird strker umrandet	*
			   * gezeichnet. Der Text fr die Knpfe wird	*
			   * durch den gleichen Zeilentrenner wie beim	*
			   * Text (s.o.) getrennt.			*/
  AES( 52, 1, 1, 1, 0 );

  return intout[0]; /* = fo_aexbttn: Nummer des Knopfes, der vom	*
		     * Benutzer zur Quittierung bettigt wurde: 	*
		     *		1 = erster Knopf			*
		     *		2 = zweiter Knopf			*
		     *		3 = dritter Knopf			*/
}
/* siehe auch: form_errorFORM_ERR.C */

