/*
 *  EVNT_MOUSE                                  (C) Digital Design 1990
 *
 *  AES wartet, bis der Mauszeiger ein bestimmtes rechteckig umgrenztes
 *  Feld betritt oder verlt.
 */
#include <gemdefs.h>

int evnt_mouse( int ev_moflags, int ev_mox, int ev_moy,
                int ev_mowidth, int ev_moheight, int *ev_momx,
                int *ev_momy, int *ev_mobutton,
                int *ev_mokstate )
{
  intin[0] = ev_moflags; /* Gibt an, welche der beiden Teilfunktionen   *
                          * aktiviert werden soll:                      *
                          *     0 = Funktion bei Eintritt in das        *
                          *         Rechteck beenden                    *
                          *     1 = Funktion bei Austritt aus dem       *
                          *         Rechteck beenden                    */
  intin[1] = ev_mox;      /* X-Koordinate des Rechtecks                 */
  intin[2] = ev_moy;      /* Y-Koordinate des Rechtecks                 */
  intin[3] = ev_mowidth;  /* Breite des Rechtecks                       */
  intin[4] = ev_moheight; /* Hhe des Rechtecks                         */

  AES( 22, 5, 5, 0, 0 );

  *ev_momx = intout[0]; /* X-Position des Mauszeigers beim Auslsen des *
                         * Ereignisses                                  */
  *ev_momy = intout[2]; /* Y-Position des Mauszeigers beim Auslsen des *
                         * Ereignisses                                  */
  *ev_mobutton = intout[3]; /* Status der Maustasten beim Auslsen des  *
                             * Ereignisses. Es gilt folgende Tastenbe-  *
                             * legung:                                  *
                             *          1 = linker Knopf                *
                             *          2 = rechter Knopf               *
                             * Bit = 0: Taste nicht bettigt            *
                             * Bit = 1: Taste bettigt                  */
  *ev_mokstate = intout[4]; /* Status der Tastatur beim Auslsen des    *
                             * Ereignisses:                             *
                             *          1 = rechte Shift-Taste          *
                             *          2 = linke Shift-Taste           *
                             *          4 = Contrl-Taste                *
                             *          8 = Alternate-Taste             *
                             * Bit = 0: Taste nicht bettigt            *
                             * Bit = 1: Taste bettigt                  */
  return intout[0]; /* = ev_moresvd: reserviert fr zuknftige Anwen-   *
                     * dungen; wird immer auf 1 gesetzt.                */
}
/* siehe auch: EVNT_MULTIEVNT_MUL.C */
